/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.bpmobject.msg.BpmObjectMsg;
import oracle.bpm.designer.ObjectContainerDialog;
import oracle.bpm.designer.action.ModuleAction;
import oracle.bpm.designer.action.OpenObjectAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.exception.ReadOnlyException;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.SOASchemaInfo;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.BpmObject;
import oracle.bpm.project.model.catalog.CatalogModule;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.ui.msg.ProjectUiMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.FuegoJob;
import oracle.bpm.ui.FuegoWorker;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import org.jetbrains.annotations.Nullable;

public class NewBpmObjectAction
extends ModuleAction {
    private CatalogObject businessObject;
    private boolean openEditor;
    private CatalogModule parent;

    public NewBpmObjectAction() {
        this((CatalogModule)null);
    }

    public NewBpmObjectAction(CatalogModule parent) {
        super(DesignerMsg.NEW_BPMOBJECT);
        this.setExcludeDefault(true);
        this.setExcludeRoot(true);
        this.parent = parent;
        this.setShowOnDisabled(false);
        this.setOpenEditor(true);
    }

    public void setOpenEditor(boolean value) {
        this.openEditor = value;
    }

    @Override
    public boolean doIt() {
        if (this.parent == null) {
            this.parent = (CatalogModule)this.getSelection().as(CatalogModule.class);
        }
        return this.newFuegoObject();
    }

    public void unDoIt() {
    }

    public CatalogObject getBusinessObject() {
        return this.businessObject;
    }

    private boolean createBpmObject(final CatalogModule parent, final String name, String description, final CatalogObject schema, final @Nullable SOASchemaInfo schemaInfo) {
        CatalogObject newType = (CatalogObject)FuegoWorker.post((FuegoJob)new FuegoJob<CatalogObject>(){

            public CatalogObject run() {
                try {
                    BpmObject result = schema != null ? (schemaInfo != null && schemaInfo.isExternalToProject() ? ((CatalogObjectImpl)parent).newBpmObjectFromExternalSchema(name, schemaInfo) : parent.newBpmObjectFromSchema(name, schema)) : parent.newBpmObject(name);
                    return result;
                }
                catch (ProjectException e) {
                    return null;
                }
            }
        });
        try {
            parent.asMutable().addChild((ProjectObject)newType);
            if (this.openEditor) {
                OpenObjectAction oca = new OpenObjectAction(newType);
                oca.runWithSelection(newType);
            }
            this.businessObject = newType;
            return true;
        }
        catch (ReadOnlyException e) {
            MessageDialog.showError((Msg)e.getMsg());
            return false;
        }
        catch (ProjectException e) {
            MessageDialog.showError((Msg)e.getMsg());
            return false;
        }
    }

    private boolean newFuegoObject() {
        ObjectContainerDialog dialog = new ObjectContainerDialog(Ui.getRoot(), ProjectUiMsg.CREATE((Msg)BpmObjectMsg.BPM_OBJECT), BpmObjectMsg.BPM_OBJECT, BpmObjectMsg.BPM_OBJECT_PREFIX.toString(), (CatalogObject)this.parent);
        dialog.setVisible(true);
        if (dialog.userAccepted()) {
            CatalogModule parent = dialog.getParentModule();
            String name = dialog.getObjectName();
            CatalogObject schema = dialog.getExternalSchema();
            SOASchemaInfo schemaInfo = dialog.getSoaSchemaInfo();
            return this.createBpmObject(parent, name, "", schema, schemaInfo);
        }
        return false;
    }
}

