/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.type.TypeChooserPanel;
import oracle.bpm.designer.type.TypeChooserUseCase;
import oracle.bpm.designer.types.DetailedCILTypeComboBox;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.lang.IllegalTypeException;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.ui.msg.ProjectUiMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.ui.IdentifierTextField;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.WindowAdapter;
import oracle.bpm.ui.event.WindowEvent;
import oracle.bpm.ui.event.WindowListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;

public class NewAttributeDialog
extends OkCancelDialog {
    private IdentifierTextField name;
    private ComponentCatalog repository;
    private TypeChooserPanel typeChooserPanel;

    private NewAttributeDialog(UiWindow parent, Project project, ComponentCatalog componentCatalog, String initialText) {
        super(parent, ProjectUiMsg.CREATE((Msg)DesignerMsg.STD_ATTRIBUTE));
        this.setTypeRepository(componentCatalog);
        this.init(parent, project, initialText);
    }

    public static NewAttributeDialog createDefaultPrimitiveDialog(UiWindow parent, Project project, ComponentCatalog componentCatalog, String varName) {
        return new NewAttributeDialog(parent, project, componentCatalog, varName);
    }

    public static NewAttributeDialog createPrimitiveDialog(UiWindow parent, Project project, ComponentCatalog componentCatalog, String varName) {
        return new NewAttributeDialog(parent, project, componentCatalog, varName);
    }

    public String getAttributeName() {
        return this.name.getText();
    }

    public String getSelectedTypeAsString() {
        CatalogType type = this.typeChooserPanel.getCatalogType();
        return type == null ? "" : type.getText();
    }

    public void setType(CatalogType typeRef) {
        this.typeChooserPanel.setCatalogType(typeRef);
    }

    public CatalogType getTypeRef() throws IllegalTypeException {
        CatalogType type = this.typeChooserPanel.getCatalogType();
        if (type == null) {
            throw new IllegalTypeException(this.getSelectedTypeAsString());
        }
        return type;
    }

    public void setTypeRepository(ComponentCatalog repository) {
        this.repository = repository;
    }

    public ComponentCatalog getTypeRepository() {
        return this.repository;
    }

    public void cancel() {
        this.setUserAccepted(false);
        this.setVisible(false);
        this.dispose();
    }

    public void ok() {
        Msg errorMessage = this.validateInput();
        if (errorMessage != null) {
            MessageDialog.showError((Msg)errorMessage);
            return;
        }
        this.setUserAccepted(true);
        this.setVisible(false);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.setUserAccepted(false);
        }
        super.setVisible(visible);
    }

    public boolean shouldOpenAttribute() {
        return false;
    }

    protected DetailedCILTypeComboBox buildTypesCombo(Panel container, ComponentCatalog repository) {
        return new DetailedCILTypeComboBox((UiContainer)container, repository);
    }

    private Msg validateInput() {
        if (!this.typeChooserPanel.isValidType()) {
            return DesignerMsg.NO_TYPE;
        }
        return null;
    }

    private void init(UiWindow parent, Project project, String initialText) {
        this.initGui(project, initialText);
        this.pack();
        this.setResizable(true);
        this.setLocationRelativeTo((UiComponent)parent);
    }

    private void initGui(Project project, String initialText) {
        Panel panel = new Panel(this.getContentPane());
        panel.setLayout((Layout)new MigLayout("ins 5, gap 5, fillx"));
        Label idLabel = Label.create((UiContainer)panel, (Msg)ProjectDrawMsg.NAME);
        this.name = new IdentifierTextField((UiContainer)panel, initialText, 35, false, false);
        this.name.setSelectionStart(0);
        this.name.setSelectionEnd(this.name.getText().length());
        Label typeLabel = Label.create((UiContainer)panel, (Msg)CoreMsg.TYPE);
        ComponentCatalog catalog = this.getTypeRepository();
        assert (catalog != null) : "Must set a DefaultComponentCatalog first";
        this.typeChooserPanel = TypeChooserPanel.create((UiContainer)panel, project, TypeChooserUseCase.BUSINESS_OBJECT_ATTRIBUTE);
        panel.add((UiComponent)idLabel);
        panel.add((UiComponent)this.name, (Object)"growx, wrap");
        panel.add((UiComponent)typeLabel, (Object)"top");
        panel.add((UiComponent)this.typeChooserPanel, (Object)"growx, wrap");
        this.getContentPane().add((UiComponent)panel);
        this.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                NewAttributeDialog.this.cancel();
            }
        });
        this.name.grabFocus();
    }
}

