/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.DesignerApplication;
import oracle.bpm.designer.ProjectNavigatorTree;
import oracle.bpm.designer.ProjectObjectTreeNode;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.tree.TreeNode;
import oracle.bpm.ui.tree.TreePath;

public class MultipleDeleteAction
extends DesignerAction {
    private int mode = -1;
    private ProjectNavigatorTree navigatorTree;
    public static final int ONCE = 0;
    public static final int FOREACH = 1;

    public MultipleDeleteAction() {
        this((ProjectNavigatorTree)null);
    }

    public MultipleDeleteAction(ProjectNavigatorTree navigatorTree) {
        this(navigatorTree, 1);
    }

    public MultipleDeleteAction(ProjectNavigatorTree navigatorTree, int mode) {
        super(UIMsg.MENU_DELETE);
        if (mode < 0 || mode > 1) {
            throw new IllegalArgumentException("Invalid mode argument");
        }
        this.setNavigatorTree(navigatorTree);
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    @Override
    public boolean doIt() {
        int answer = MessageDialog.showQuestion((UiContainer)null, (Msg)UIMsg.MENU_DELETE, (Msg)DesignerMsg.CONFIRM_MULTIPLE_DELETE, null, (int)6, null);
        if (answer != 2) {
            return false;
        }
        if (!UiUtilities.isEventDispatchThread()) {
            this.doInvoke();
        } else {
            UiUtilities.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    MultipleDeleteAction.this.doInvoke();
                }
            });
        }
        return true;
    }

    public void unDoIt() {
    }

    private void setNavigatorTree(ProjectNavigatorTree navigatorTree) {
        this.navigatorTree = navigatorTree;
    }

    private ProjectNavigatorTree getNavigatorTree() {
        if (this.navigatorTree == null) {
            DesignerApplication instance = DesignerApplication.getInstance();
            this.navigatorTree = AbstractStudioWorkbench.getInstance().getProjectTree();
        }
        return this.navigatorTree;
    }

    private void doInvoke() {
        int mode = this.getMode();
        TreePath[] selectionPaths = this.getNavigatorTree().getSelectionPaths();
        assert (selectionPaths != null && selectionPaths.length > 1) : "Invalid selections for multiple delete action!";
        if (mode == 1) {
            this.invokeMultiple(selectionPaths);
        } else if (mode == 0) {
            this.invokeOnce(selectionPaths);
        } else assert (false) : "Invalid mode for action";
    }

    private void invokeAction(BaseAction action) {
        if (action == null) {
            return;
        }
        action.actionPerformed(new ActionEvent((Object)this.getNavigatorTree(), "delete-action"));
    }

    private void invokeMultiple(TreePath[] selectionPaths) {
        for (TreePath path : selectionPaths) {
            TreeNode node = (TreeNode)path.getLastPathComponent();
            BaseAction action = (BaseAction)node.getCommonActionsMap().get("delete-action");
            this.invokeAction(action);
        }
    }

    private void invokeOnce(TreePath[] selectionPaths) {
        TreePath path = selectionPaths[0];
        ProjectObjectTreeNode node = (ProjectObjectTreeNode)((Object)path.getLastPathComponent());
        BaseAction action = (BaseAction)node.getCommonActionsMap().get("delete-action");
        this.invokeAction(action);
    }
}

