/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.action.NewModuleAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.navigator.ProjectNavigatorBuilder;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogModule;
import oracle.bpm.project.view.filter.ProjectFilters;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.selection.Selection;

public abstract class ModuleAction
extends DesignerAction {
    private boolean excludeDefault;
    private boolean excludeRoot;

    public ModuleAction(Msg msg) {
        super(msg);
        this.requires(CatalogModule.class);
    }

    public static CatalogModule selectModule(Project project) {
        final ProjectNavigatorBuilder builder = new ProjectNavigatorBuilder((ProjectObject)project.getCatalogRoot(), DesignerMsg.BROWSE_MODULES);
        builder.filter(ProjectFilters.BUSINESS_CATALOG_MODULES);
        NewModuleAction newModule = new NewModuleAction(project.getCatalogRoot()){

            @Override
            public void run() {
                super.run();
                builder.selectOnTree((ProjectObject)this.getNewlyCreated());
            }
        };
        newModule.setMsg(DesignerMsg.NEW_MODULE);
        builder.addAction(newModule);
        builder.initialSelection((ProjectObject)project.getCatalogRoot());
        builder.showRoot();
        return builder.selectSingle(CatalogModule.class);
    }

    public void setExcludeDefault(boolean excludeDefault) {
        this.excludeDefault = excludeDefault;
    }

    public boolean isExcludeDefault() {
        return this.excludeDefault;
    }

    public void setExcludeRoot(boolean excludeRoot) {
        this.excludeRoot = excludeRoot;
    }

    public boolean isExcludeRoot() {
        return this.excludeRoot;
    }

    protected void updateEnableStatus(Selection selection) {
        CatalogModule module = (CatalogModule)selection.as(CatalogModule.class);
        if (module == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
        if (this.isExcludeRoot()) {
            this.setEnabled(!module.isRootModule());
        }
        if (this.isExcludeDefault()) {
            this.setEnabled(!module.isDefault());
        }
    }
}

