/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.MethodsListDialog;
import oracle.bpm.designer.action.OpenCloseMemberAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.selection.Selection;

public class MethodsListAction
extends DesignerAction {
    ObjectTypeDescription objectType;

    public MethodsListAction() {
        super(DesignerMsg.CIL_LIST);
        this.requires(ObjectTypeDescription.class);
        this.setShowOnDisabled(false);
    }

    public MethodsListAction(ObjectTypeDescription otd) {
        this();
        this.objectType = otd;
    }

    public void setObjectType(ObjectTypeDescription objectType) {
        this.objectType = objectType;
    }

    @Override
    public boolean doIt() {
        if (this.objectType == null) {
            return false;
        }
        MethodsListDialog methodsListDialog = new MethodsListDialog(Ui.getRoot(), this.objectType);
        methodsListDialog.setVisible(true);
        if (methodsListDialog.userAccepted()) {
            MethodTypeDescription selectedMTD = methodsListDialog.getSelectedMethod();
            if (selectedMTD == null) {
                return false;
            }
            OpenCloseMemberAction.openMember(selectedMTD);
            return true;
        }
        return false;
    }

    public void unDoIt() {
    }

    protected void updateEnableStatus(Selection selection) {
        CatalogObject objectType = (CatalogObject)selection.as(CatalogObject.class);
        this.setEnabled(objectType.isBpmObject() && !objectType.isInnerType());
    }
}

