/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.command.Command;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.LanePropertiesDialog;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.command.design.SwitchLaneCommand;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.ui.ActionOrder;
import oracle.bpm.ui.Ui;

public class LanePropertiesAction
extends DesignerAction {
    private static LanePropertiesAction instance;

    private LanePropertiesAction() {
        super(DesignerMsg.PROPERTIES);
        this.setOrder(ActionOrder.FIRST);
        this.requires(Lane.class);
    }

    public static LanePropertiesAction getInstance() {
        if (instance == null) {
            instance = new LanePropertiesAction();
        }
        return instance;
    }

    @Override
    public void run() {
        Lane lane = this.getLane();
        LanePropertiesDialog dialog = new LanePropertiesDialog(Ui.getRoot(), lane, !ModelUtils.containsInteractive((Lane)lane));
        dialog.setVisible(true);
        if (dialog.userAccepted()) {
            this.getRunner().run((Command)new SwitchLaneCommand(lane, dialog.getLaneName(), dialog.getBackgroundColor().getRGB(), dialog.getCustomImageId()));
        }
    }

    public boolean isEnabled() {
        return super.isEnabled();
    }

    private Lane getLane() {
        return (Lane)this.getSelection().as(Lane.class);
    }
}

