/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.command.Command;
import oracle.bpm.designer.action.AddLaneAction;
import oracle.bpm.geom.Point;
import oracle.bpm.project.LaneImpl;
import oracle.bpm.project.command.design.InsertLaneCommand;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.LaneUtils;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;

public class InsertLaneAction
extends AddLaneAction {
    public static final int INSERT_IN_THE_MIDDLE = -1;

    private InsertLaneAction(@NotNull Process process, int offset) {
        super(process, offset);
    }

    public static AddLaneAction createInsertRoleAction(@NotNull Lane newRole, @NotNull Point offset) {
        AddLaneAction action = InsertLaneAction.createInsertRoleAction(newRole.getProcess(), offset);
        action.setNewLane(newRole);
        return action;
    }

    public static AddLaneAction createInsertRoleAction(@NotNull Process content, @NotNull Point location) {
        int offset = ModelUtils.isHorizontal((Process)content) ? location.getY() : location.getX();
        int whereToInsert = InsertLaneAction.whereToInsert(content, offset);
        if (whereToInsert == -1) {
            return new InsertLaneAction(content, offset);
        }
        return new AddLaneAction(content, whereToInsert);
    }

    public static int whereToInsert(Process content, int offset) {
        int result;
        LaneImpl destinationRole = (LaneImpl)LaneUtils.getLane((Process)content, (int)offset);
        if (destinationRole == null) {
            Lane lastLane = LaneUtils.getLastLane((Process)content);
            result = lastLane.getOffset() + lastLane.getSize();
        } else {
            boolean before = false;
            boolean after = false;
            for (FlowNode node : destinationRole.getActivities()) {
                double x = InsertLaneAction.getNodeOffset(content, node);
                if (x > (double)offset) {
                    after = true;
                } else {
                    before = true;
                }
                if (!before || !after) continue;
                break;
            }
            result = after && before ? -1 : (after ? destinationRole.getOffset() : destinationRole.getOffset() + destinationRole.getSize());
        }
        return result;
    }

    @Override
    public void run() {
        AddLaneAction.LaneInfo laneInfo = this.askLaneInfo();
        if (laneInfo != null) {
            this.getRunner().run((Command)new InsertLaneCommand(this.process, laneInfo.getRoleId(), laneInfo.getBackgroundColor(), this.offset));
        }
    }

    private static int getNodeOffset(Process content, FlowNode node) {
        return ModelUtils.isHorizontal((Process)content) ? node.getY() : node.getX();
    }
}

