/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.bpmobject.msg.BpmObjectMsg;
import oracle.bpm.compiler.CodeKit;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NullConst;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.ObjectContainerDialog;
import oracle.bpm.designer.action.OpenObjectAction;
import oracle.bpm.designer.cileditor.SuperTypeProperty;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.editor.EditorPreferences;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.BpmObject;
import oracle.bpm.project.model.catalog.CatalogModule;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.type.Argument;
import oracle.bpm.type.SourceCode;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.selection.Selection;

public class InheritAction
extends DesignerAction {
    CatalogObject source;
    private boolean open = true;
    private Project project;
    private CatalogObject xobjectTarget;

    public InheritAction(CatalogObject parent) {
        super(DesignerMsg.CREATE_TYPE_IMPL);
        this.project = parent.getProject();
        this.source = parent;
        this.requires(CatalogObject.class);
        this.setShowOnDisabled(false);
    }

    public InheritAction(CatalogObject parent, CatalogObject xobjectTarget) {
        this(parent);
        this.xobjectTarget = xobjectTarget;
    }

    public static MethodTypeDescription overrideMember(MethodTypeDescription member) {
        Argument[] arguments;
        MethodTypeDescription cloned = member.clone();
        cloned.setParent(null);
        cloned.clearModifier(0x2000200L);
        cloned.addModifiers(524288L);
        cloned.setSignature("");
        cloned.getProperties().clear();
        TypeDescription resultType = cloned.getResultType();
        if (resultType.getKind() != 0) {
            EditorPreferences editorPreferences = EditorPreferences.getInstance();
            LanguageSpec defaultLanguage = editorPreferences.getLanguageSpec();
            StringWriter writer = new StringWriter();
            SourceGenerator generator = defaultLanguage.createSourceGenerator();
            generator.setWriter((Writer)writer);
            Node rtrnStmt = CodeKit.createReturn((Node)Const.defaultValue((TypeDescription)resultType, (Node)new NullConst()));
            rtrnStmt.generate(generator);
            generator.close();
            SourceCode sourceCode = SourceCode.create(writer.toString(), defaultLanguage.getName());
            cloned.setCode(sourceCode);
        }
        if (cloned.isAttribute()) {
            cloned.asAttribute().setWriteSignature("");
        }
        for (Argument argument : arguments = cloned.getArguments()) {
            argument.getProperties().clear();
            argument.clearModifier(2048L);
        }
        return cloned;
    }

    public CatalogObject getSource() {
        return this.source;
    }

    @Override
    public boolean doIt() {
        if (this.xobjectTarget == null) {
            return this.createImplementation();
        }
        return this.implementMethods(this.xobjectTarget);
    }

    protected void updateEnableStatus(Selection selection) {
        CatalogObject objectType = (CatalogObject)selection.as(CatalogObject.class);
        this.setEnabled(!objectType.isModule() && SuperTypeProperty.isImplementable(objectType.getDelegate()));
    }

    private boolean isSameMethod(MethodTypeDescription method, MethodTypeDescription member) {
        return method.equals(member);
    }

    private CatalogObject createFuegoObject(CatalogModule parent, String name) throws ProjectException {
        BpmObject target = parent.newBpmObject(name);
        target.getObjectType().addSuperType(new SuperType(this.source.getObjectType(), 32768L));
        if (Modifier.isException(this.source.getObjectType().getModifiers())) {
            target.getObjectType().setModifiers(Modifier.setException(target.getObjectType().getModifiers(), true));
        }
        this.implementMethods((CatalogObject)target);
        parent.asMutable().addChild((ProjectObject)target);
        return target;
    }

    private boolean createImplementation() {
        CatalogObject type = this.getSource();
        CatalogObject module = CatalogObjectImpl.create((TypeRef)type.getObjectType().getParent().getParent().asObject());
        String name = type.getId();
        int index = name.indexOf("Listener");
        if (index != -1) {
            name = name.substring(0, index);
        }
        name = name + "Impl";
        if (module.isDefault()) {
            module = null;
        }
        ObjectContainerDialog dialog = new ObjectContainerDialog(Ui.getRoot(), DesignerMsg.NEW_BPMOBJECT, BpmObjectMsg.BPM_OBJECT, name, module, this.project);
        dialog.setVisible(true);
        if (dialog.userAccepted()) {
            CatalogObject newObject;
            CatalogModule parent = dialog.getParentModule();
            String target = dialog.getObjectName();
            try {
                newObject = this.createFuegoObject(parent, target);
            }
            catch (ProjectException e) {
                MessageDialog.showError((Throwable)e);
                return false;
            }
            if (newObject != null) {
                if (this.open) {
                    new OpenObjectAction(newObject).run();
                }
                return true;
            }
        }
        return false;
    }

    private boolean implementMethods(CatalogObject target) {
        CatalogObject source = this.getSource();
        List<MethodTypeDescription> members = source.getObjectType().getMethods();
        ArrayList<MethodTypeDescription> toAddList = new ArrayList<MethodTypeDescription>();
        ArrayList<MethodTypeDescription> conflictedMethods = new ArrayList<MethodTypeDescription>();
        for (MethodTypeDescription member : members) {
            if (!member.isAbstract() && !source.getObjectType().isInterface()) continue;
            MethodTypeDescription targetMethod = target.getObjectType().getMember(member.getName(), 14);
            boolean methodConflics = false;
            boolean doAddMethod = true;
            if (targetMethod != null) {
                doAddMethod = false;
                boolean isSame = this.isSameMethod(targetMethod, member);
                if (!isSame) {
                    methodConflics = true;
                }
            }
            MethodTypeDescription cloned = InheritAction.overrideMember(member);
            if (doAddMethod) {
                toAddList.add(cloned);
            }
            if (!methodConflics) continue;
            conflictedMethods.add(cloned);
        }
        boolean solved = this.solveConflict(conflictedMethods);
        if (!solved) {
            return false;
        }
        toAddList.addAll(conflictedMethods);
        for (MethodTypeDescription methodType : toAddList) {
            target.getObjectType().addMember(methodType);
        }
        return true;
    }

    private boolean solveConflict(List<MethodTypeDescription> conflictedMethods) {
        return true;
    }
}

