/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.LinkedList;
import oracle.bpm.designer.DesignerMode;
import oracle.bpm.designer.ModelContainerTreeNode;
import oracle.bpm.designer.SingleProcessFilePreviewer;
import oracle.bpm.designer.action.OpenObjectAction;
import oracle.bpm.designer.importer.DrawingImporter;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.log.Log;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.processmodel.SchemaType;
import oracle.bpm.project.command.design.LayoutModelCommand;
import oracle.bpm.project.importer.CancelActionException;
import oracle.bpm.project.importer.ModelImporter;
import oracle.bpm.project.io.fs.FileProjectWriter;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectWriter;
import oracle.bpm.project.model.exception.ImporterException;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.SwingWorker;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.filechooser.FileChooser;
import oracle.bpm.ui.monitor.ProgressDialog;
import oracle.bpm.ui.monitor.ProgressMonitorBuilder;
import oracle.bpm.util.CommonPreferences;
import oracle.bpm.util.FileUtils;
import oracle.bpm.util.ProgressMonitor;

public class ImportProcessesAction
extends BaseAction {
    private int currentCount_d;
    private DrawingImporter drawingImporter;
    private int totalCount_d;

    public ImportProcessesAction() {
        super(DesignerMsg.IMPORT_DESIGNS);
        this.requires(FolderContainer.class);
    }

    public void run() {
        try {
            this.importProcesses();
        }
        catch (FileNotFoundException e) {
            MessageDialog.showError((Throwable)e);
        }
        catch (ProjectException e) {
            MessageDialog.showError((Throwable)e);
        }
    }

    public boolean showsDialog() {
        return true;
    }

    private FileChooser fileDialog(DrawingImporter importer) {
        FileChooser fc = new FileChooser();
        LinkedList<oracle.bpm.util.FileFilter> filters = new LinkedList<oracle.bpm.util.FileFilter>();
        oracle.bpm.util.FileFilter processFilter = SchemaType.PROCESS.getFileFilter();
        filters.add(processFilter);
        if (DesignerMode.isValid(2)) {
            filters.add(SchemaType.PROCEDURE.getFileFilter());
            filters.add(SchemaType.SCREENFLOW.getFileFilter());
        }
        if (importer != null) {
            for (ModelImporter imp : importer.getImporters()) {
                filters.add(imp.getFileFilter());
            }
        }
        SingleProcessFilePreviewer a = new SingleProcessFilePreviewer(Ui.getRoot(), fc, this.getProject());
        fc.setAccessory((UiComponent)a);
        fc.setName("import.process");
        for (oracle.bpm.util.FileFilter filter : filters) {
            fc.addChoosableFileFilter(filter);
        }
        fc.setFileFilter(processFilter);
        fc.setAcceptAllFileFilterUsed(true);
        return fc;
    }

    private boolean addDirToProject(File source, FolderContainer destination, FileFilter filter, ProgressMonitor monitor) throws ProjectException, FileNotFoundException {
        File[] files;
        if (!source.isDirectory()) {
            return false;
        }
        for (File file : files = source.listFiles(filter)) {
            if (!file.isDirectory()) {
                if (monitor != null) {
                    ++this.currentCount_d;
                    monitor.progress(this.currentCount_d * 100 / this.totalCount_d);
                    monitor.info(CoreMsg.COPYING_INTO(file.getName(), destination.getPath().toString()));
                }
                try {
                    this.importProcess(file, destination);
                    continue;
                }
                catch (CancelActionException exc) {
                    break;
                }
            }
            FolderContainer newContainer = destination.createContainer(file.getName());
            destination.addChild((ProjectObject)newContainer);
            ProjectWriter projectWriter = destination.getProject().getWriter();
            projectWriter.write(new ProjectObject[]{newContainer});
            destination = newContainer;
            this.addDirToProject(file, destination, filter, monitor);
        }
        return true;
    }

    private DrawingImporter getDrawingImporter() {
        if (this.drawingImporter == null) {
            this.drawingImporter = new DrawingImporter(DesignerPreferences.getPreferences());
        }
        return this.drawingImporter;
    }

    private File[] getSelectedFiles() throws CancelActionException {
        int retValue;
        FileChooser fc = this.fileDialog(this.getDrawingImporter());
        String lastUsedFile = CommonPreferences.getInstance().getLastUsedFile();
        if (lastUsedFile != null) {
            oracle.bpm.util.FileFilter[] fileFilters;
            File lastUsed = new File(lastUsedFile);
            for (oracle.bpm.util.FileFilter fileFilter : fileFilters = fc.getChoosableFileFilters()) {
                if (!fileFilter.accept(lastUsed)) continue;
                fc.setFileFilter(fileFilter);
                break;
            }
        }
        if ((retValue = fc.showOpenDialog((UiComponent)Ui.getRoot(), DesignerMsg.IMPORT_DESIGNS, 1)) != 0 || fc.getSelectedFile() == null) {
            throw new CancelActionException();
        }
        CommonPreferences.getInstance().setLastUsedFile(fc.getSelectedFile().getAbsolutePath());
        return fc.getSelectedFiles();
    }

    private boolean importDirectory(final File sourceDir, final FolderContainer modelContainer) {
        ProgressMonitorBuilder builder = ProgressMonitorBuilder.createSimpleBuilder();
        final ProgressDialog dialog = builder.buildProgressDialog(Ui.getRoot(), DesignerMsg.IMPORT_DESIGNS);
        final ProgressMonitor monitor = dialog.getProgressMonitor();
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                dialog.setVisible(true);
                monitor.phase(DesignerMsg.IMPORTING_PROCESSES);
                FileFilter fileFilter = FileProjectWriter.getSchemasFileFilter((boolean)true, (boolean)true);
                ImportProcessesAction.this.totalCount_d = FileUtils.countFiles(sourceDir, fileFilter);
                ImportProcessesAction.this.currentCount_d = 0;
                try {
                    ImportProcessesAction.this.addDirToProject(sourceDir, modelContainer, fileFilter, monitor);
                }
                catch (ProjectException e) {
                    MessageDialog.showError((Throwable)e);
                    Log.logDebug(e);
                }
                catch (FileNotFoundException e) {
                    MessageDialog.showError((Throwable)e);
                    Log.logDebug(e);
                }
                return null;
            }

            public void finished() {
                try {
                    FolderContainer newNode = modelContainer.createContainer(sourceDir.getName());
                    modelContainer.addChild((ProjectObject)newNode);
                    dialog.setVisible(false);
                }
                catch (ProjectException e) {
                    MessageDialog.showError((Throwable)e);
                    Log.logDebug(e);
                }
            }
        };
        worker.start();
        return true;
    }

    private Process[] importDrawing(File sourceFile, FolderContainer modelContainer) throws ProjectException {
        Collection<Process> contents = this.getDrawingImporter().importDrawing(sourceFile, modelContainer.getProject());
        Process[] processes = new Process[contents != null ? contents.size() : 0];
        if (contents != null) {
            int i = 0;
            for (Process model : contents) {
                modelContainer.addChild((ProjectObject)model);
                processes[i] = model;
                ++i;
            }
        }
        this.getDrawingImporter().postImport(sourceFile, processes);
        return processes;
    }

    private void autolayout(Process model) {
        try {
            new LayoutModelCommand(model, true).execute();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    private void importFile(File sourceFile, FolderContainer destinationDir) throws FileNotFoundException, ProjectException {
        try {
            Process[] processes = this.importProcess(sourceFile, destinationDir);
            if (processes == null) {
                return;
            }
            for (Process process : processes) {
                this.autolayout(process);
                new OpenObjectAction(process).run();
            }
        }
        catch (CancelActionException cancelActionException) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Process[] importProcess(File sourceFile, FolderContainer destinationDir) throws FileNotFoundException {
        try {
            if (!DrawingImporter.isFuegoProcess(sourceFile, (ProjectObject)destinationDir.getProject())) {
                String extension = FileUtils.getExtension(sourceFile);
                if (this.getDrawingImporter().isRegisteredExtension(extension)) {
                    return this.importDrawing(sourceFile, destinationDir);
                }
                MessageDialog.showError((Msg)DesignerMsg.UNKNOWN_DESIGN_FILE_EXTENSION(extension));
                return null;
            }
            Process process = ModelContainerTreeNode.importProcessFile(sourceFile, destinationDir);
            if (process == null) return null;
            Process[] processes = new Process[]{process};
            return processes;
        }
        catch (ImporterException importerException) {
            Log.logWarning(importerException.getMsg());
            MessageDialog.showError((Throwable)importerException);
            return null;
        }
        catch (ProjectException projectException) {
            Log.logWarning(projectException.getMsg());
            MessageDialog.showError((Throwable)projectException);
            return null;
        }
    }

    private boolean importProcesses() throws ProjectException, FileNotFoundException {
        File[] files;
        for (File source : files = this.getSelectedFiles()) {
            if (!source.exists()) {
                MessageDialog.showError((Msg)ProjectMsg.FILE_NOT_FOUND((String)source.getPath()));
                continue;
            }
            if (source.isDirectory()) {
                this.importDirectory(source, this.getModelContainer());
                continue;
            }
            this.importFile(source, this.getModelContainer());
        }
        return true;
    }

    private FolderContainer getModelContainer() {
        return (FolderContainer)this.getSelection().as(FolderContainer.class);
    }

    private Project getProject() {
        return this.getModelContainer().getProject();
    }
}

