/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import java.io.File;
import java.util.Set;
import oracle.bpm.bpmobject.importexport.BusinessObjectImporter;
import oracle.bpm.bpmobject.importexport.ImportExportException;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.action.ReloadCatalogAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogModule;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.DialogFactory;
import oracle.bpm.ui.HiddenMessagesPreferences;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.filechooser.FileChooser;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.util.FileFilter;

public class ImportBPMObjectAction
extends DesignerAction {
    private TypeRef parentNode = null;
    private boolean requiresModuleSelection = true;

    public ImportBPMObjectAction() {
        super(DesignerMsg.IMPORT_BPM_OBJECT);
        this.requires(CatalogModule.class);
    }

    public ImportBPMObjectAction(CatalogObject object) {
        this();
        this.setShowOnDisabled(false);
        this.parentNode = object != null ? object.getObjectType() : null;
        this.requiresModuleSelection = this.parentNode == null;
    }

    @Override
    public void run() {
        try {
            final File file = this.selectFileToImport();
            if (file != null) {
                final VFileSystem fileSystem = this.getProject().getLoader().getProjectFileSystem().getDataFileSystem();
                boolean hasConflicts = BusinessObjectImporter.hasConflicts((File)file, (VFileSystem)fileSystem);
                if (hasConflicts) {
                    Set conflicts = BusinessObjectImporter.getConflicts((File)file, (VFileSystem)fileSystem);
                    StringBuffer errors = new StringBuffer();
                    for (String s : conflicts) {
                        errors.append("\n");
                        errors.append(s);
                    }
                    MessageDialog.showError((Msg)DesignerMsg.IMPORT_BPM_OBJECT_ERROR, (Msg)DesignerMsg.THE_FOLLOWING_FILES_DONT_MERGE(errors.toString()));
                } else {
                    ProjectCommand command = new ProjectCommand(new ProjectObject[]{this.getProject().getCatalogRoot()}){

                        public String getName() {
                            return "import bpmobjects";
                        }

                        public Object execute() throws ExecutionException {
                            try {
                                BusinessObjectImporter.merge((File)file, (VFileSystem)fileSystem, (ComponentCatalog)ImportBPMObjectAction.this.parentNode.getCatalog());
                            }
                            catch (ImportExportException iee) {
                                MessageDialog.showError((Msg)DesignerMsg.IMPORT_BPM_OBJECT, (Msg)DesignerMsg.ERROR_IMPORTING, (Throwable)iee);
                            }
                            return true;
                        }
                    };
                    command.execute();
                    new ReloadCatalogAction((CatalogObject)this.getProject().getCatalogRoot()).doIt();
                }
            }
        }
        catch (ImportExportException iee) {
            MessageDialog.showError((Msg)DesignerMsg.IMPORT_BPM_OBJECT, (Msg)DesignerMsg.ERROR_IMPORTING, (Throwable)iee);
        }
    }

    public void unDoIt() {
    }

    protected void updateEnableStatus(Selection selection) {
        CatalogModule module = (CatalogModule)selection.as(CatalogModule.class);
        this.setEnabled(module != null && module.isRootModule());
    }

    private FileChooser buildFileChooser() {
        FileChooser chooser = new FileChooser();
        chooser.setName("import.object");
        FileFilter filter = FileFilter.create(UIMsg.EXPORTED_FOBJECT_FILES, ".bob");
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(filter);
        return chooser;
    }

    private boolean selectOverwriteCriteria() {
        boolean confirm;
        DesignerPreferences preferences = DesignerPreferences.getPreferences();
        Msg titleMsg = DesignerMsg.OVERWRITE_FILES;
        Msg confirmMsg = DesignerMsg.CONFIRM_OVERWRITE_FILES;
        boolean oldValue = Boolean.valueOf(preferences.getMessageValue(confirmMsg.getCode()));
        if (oldValue != (confirm = DialogFactory.showConfirmDialog((HiddenMessagesPreferences)preferences, (Msg)titleMsg, (Msg)confirmMsg))) {
            preferences.store();
        }
        return confirm;
    }

    private Project getProject() {
        ObjectTypeDescription objectType = (ObjectTypeDescription)this.getSelection().as(ObjectTypeDescription.class);
        return FuegoProject.getFrom((TypeRef)objectType);
    }

    private File selectFileToImport() {
        File result = null;
        FileChooser chooser = this.buildFileChooser();
        int returnVal = chooser.showOpenDialog((UiComponent)Ui.getRoot(), DesignerMsg.SELECT_EXPORTED_FILE_NAME, 0);
        if (returnVal == 0) {
            result = chooser.getSelectedFile();
        }
        return result;
    }
}

