/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.DesignerAction;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.selection.Selection;

public abstract class HideComponentAction
extends DesignerAction {
    private boolean newValue;
    private TypeRef typeRef;

    private HideComponentAction(Msg msg, TypeRef otd, boolean newValue) {
        super(msg);
        this.typeRef = otd;
        this.newValue = newValue;
        this.requires(ObjectTypeDescription.class);
    }

    public static boolean isUIHidden(TypeRef type) {
        return type != null && Modifier.isHidden(type.getModifiers());
    }

    public static BaseAction createHide(CatalogObject node, boolean show) {
        if (show) {
            return HideComponentAction.createShowComponent(node);
        }
        return HideComponentAction.createHideComponent(node);
    }

    public static BaseAction createHideComponent(CatalogObject node) {
        return new HideComponent(node);
    }

    public static BaseAction createShowComponent(CatalogObject node) {
        return new ShowComponent(node);
    }

    @Override
    public boolean doIt() {
        boolean oldValue = this.typeRef.get().isHidden();
        ObjectTypeDescription otd = this.typeRef.get().asObject();
        otd.setModifiers(Modifier.setModifier(this.typeRef.getModifiers(), this.newValue, 0x2000000L));
        boolean result = this.store();
        if (result) {
            this.updateUI();
        } else {
            otd.setModifiers(Modifier.setModifier(this.typeRef.getModifiers(), oldValue, 0x2000000L));
        }
        return result;
    }

    protected void updateEnableStatus(Selection selection) {
        CatalogObject catalogObject = (CatalogObject)selection.as(CatalogObject.class);
        this.setEnabled(!catalogObject.isReadOnly());
    }

    protected void updateUI() {
    }

    private MutableComponentCatalog getTypeRepository() {
        ComponentCatalog catalog = this.typeRef.getCatalog();
        return (MutableComponentCatalog)catalog;
    }

    private boolean store() {
        try {
            this.getTypeRepository().update(this.typeRef.get().asObject());
        }
        catch (TypeCatalogException e) {
            MessageDialog.showError((Throwable)e);
            return false;
        }
        return true;
    }

    private static class ShowComponent
    extends HideComponentAction {
        public ShowComponent(CatalogObject node) {
            super(CoreMsg.SHOW, node.getDelegate(), false);
        }
    }

    private static class HideComponent
    extends HideComponentAction {
        public HideComponent(CatalogObject node) {
            super(CoreMsg.HIDE, node.getDelegate(), true);
        }
    }
}

