/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.diagram.ImageProcessDiagrammer;
import oracle.bpm.draw.diagram.ProcessDiagrammer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.filechooser.FileChooser;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.utils.ImageExtension;
import oracle.bpm.ui.utils.ImageIOFacade;
import oracle.bpm.util.FileFilter;
import org.jetbrains.annotations.NotNull;

public class GenerateProcessImageAction
extends BaseAction {
    private static GenerateProcessImageAction instance;

    private GenerateProcessImageAction() {
        super(DesignerMsg.GENERATE_PROCESS_IMAGE);
        this.requires(Process.class);
    }

    public static GenerateProcessImageAction getInstance() {
        if (instance == null) {
            instance = new GenerateProcessImageAction();
        }
        return instance;
    }

    public void run() {
        Process process = this.getProcess();
        ImageProcessDiagrammer diagrammer = new ImageProcessDiagrammer(process);
        File file = this.browse();
        if (!(file == null || file.exists() && 2 != MessageDialog.showQuestion((Msg)DesignerMsg.FILE_EXISTS, (Msg)DesignerMsg.FILE_EXISTS_OVERWRITE(file.getName()), (int)6))) {
            try {
                this.storeImage(file, (ProcessDiagrammer)diagrammer);
            }
            catch (IOException e) {
                MessageDialog.showError((Throwable)e);
            }
        }
    }

    private File browse() {
        File file;
        FileChooser chooser = new FileChooser();
        FileFilter filter = FileFilter.create(UIMsg.EXPORTED_FILE_NAME, "png");
        chooser.setFileFilter(filter);
        int returnVal = chooser.showSaveDialog((UiComponent)Ui.getRoot(), DesignerMsg.SELECT_EXPORTED_FILE_NAME);
        if (returnVal == 0) {
            file = chooser.getSelectedFile();
            if (!file.getName().endsWith("png")) {
                file = new File(file.getParentFile(), file.getName() + ".png");
            }
        } else {
            file = null;
        }
        return file;
    }

    private void storeImage(@NotNull String name, @NotNull ProcessDiagrammer diagrammer) {
        try {
            File dir = new File(System.getProperty("user.home") + "/tmp/output");
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File file = new File(dir, name);
            this.storeImage(file, diagrammer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void storeImage(File file, ProcessDiagrammer diagrammer) throws IOException {
        Image image = Image.createFromBase64((String)diagrammer.getImage());
        if (!file.exists()) {
            file.createNewFile();
        }
        ImageIOFacade.writeImage((RenderedImage)((BufferedImage)image.asAwtImage()), (ImageExtension)ImageExtension.PNG, (File)file);
    }

    private Process getProcess() {
        return (Process)this.getSelection().as(Process.class);
    }
}

