/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import oracle.bpm.draw.diagram.AuditProcessDiagrammer;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.utils.ImageExtension;
import oracle.bpm.ui.utils.ImageIOFacade;
import org.jetbrains.annotations.NotNull;

public class GenerateElementImageAction
extends BaseAction {
    private static GenerateElementImageAction instance;

    private GenerateElementImageAction() {
        super(Msg.QUOTE("DEBUG MODE: Generate Element Images"));
        this.requires(FlowElement.class);
    }

    public static GenerateElementImageAction getInstance() {
        if (instance == null) {
            instance = new GenerateElementImageAction();
        }
        return instance;
    }

    public void run() {
        FlowElement element = this.getFlowElement();
        String id = element.getId();
        Process process = element.getProcess();
        AuditProcessDiagrammer diagrammer = new AuditProcessDiagrammer(process);
        this.storeImage(process.getId() + "-" + id + "-" + element.getDefaultLabel() + ".png", diagrammer.getImageForFlowElement(id));
        this.storeImage(process.getId() + "-" + id + "-" + element.getDefaultLabel() + "-icon.png", diagrammer.getIconForFlowElement(id));
        System.out.println("GenerateElementImageAction.run :: " + diagrammer.getBoundsForFlowElement(id));
    }

    private void storeImage(@NotNull String name, @NotNull String image64) {
        try {
            File file;
            Image image = Image.createFromBase64((String)image64);
            File dir = new File(System.getProperty("user.home") + "/tmp/output");
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (!(file = new File(dir, name)).exists()) {
                file.createNewFile();
            }
            ImageIOFacade.writeImage((RenderedImage)((BufferedImage)image.asAwtImage()), (ImageExtension)ImageExtension.PNG, (File)file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private FlowElement getFlowElement() {
        return (FlowElement)this.getSelection().as(FlowElement.class);
    }
}

