/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.command.Command;
import oracle.bpm.designer.ActionRunner;
import oracle.bpm.designer.action.AddLaneAction;
import oracle.bpm.designer.command.EnsureLaneCommand;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesDialog;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesPreferences;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ActionOrder;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.action.BaseAction;

public class FlowNodePropertiesAction
extends BaseAction {
    private FlowNodePropertiesPreferences preferences = FlowNodePropertiesPreferences.create();
    private static FlowNodePropertiesAction instance;

    public FlowNodePropertiesAction() {
        super(DesignerMsg.PROPERTIES);
        this.setName(this.getMsg().getString());
        this.setSmallIcon(Image.create((Msg)this.getMsg()));
        this.putValue("ShortDescription", this.getName());
        this.setOrder(ActionOrder.FIRST);
        this.requires(FlowNode.class);
    }

    public static FlowNodePropertiesAction getInstance() {
        if (instance == null) {
            instance = new FlowNodePropertiesAction();
        }
        return instance;
    }

    public void run() {
        FlowNode flowNode = this.getFlowNode();
        if (FlowNodePropertiesDialog.editProperties(flowNode, this.preferences)) {
            EnsureLaneCommand command;
            AddLaneAction.LaneInfo lane = null;
            boolean needs = EnsureLaneCommand.needsNewLane(flowNode.getLocation(), flowNode);
            if (needs) {
                lane = AddLaneAction.newLaneName(flowNode.getProcess(), false);
            }
            if (!(needs && lane == null || (command = new EnsureLaneCommand(flowNode.getLocation(), flowNode, lane)).getCommands().size() <= 0)) {
                ActionRunner.getInstance().run((Command)((Object)command));
            }
        }
    }

    public FlowNodePropertiesPreferences getPreferences() {
        return this.preferences;
    }

    private FlowNode getFlowNode() {
        return (FlowNode)this.getSelection().as(FlowNode.class);
    }
}

