/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import java.util.Iterator;
import java.util.TreeMap;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.DesignerMode;
import oracle.bpm.designer.action.AddTransitionAction;
import oracle.bpm.designer.controller.FlowNodeController;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.designer.processdesigner.states.AddingSequenceFlowState;
import oracle.bpm.diagram.editor.state.AbstractDesignerState;
import oracle.bpm.draw.themes.DefaultTheme;
import oracle.bpm.draw.themes.ImageType;
import oracle.bpm.project.ActivityImpl;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.CallActivity;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.GatewayDirection;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.TransitionType;
import oracle.bpm.project.model.processes.activities.NodeAssociationFeature;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.process.policies.SequenceFlowPolicies;
import oracle.bpm.project.ui.ModelObjectSelection;
import oracle.bpm.project.view.project.view.renderer.ProjectObjectRenderer;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.selection.DefaultSelection;
import oracle.bpm.ui.selection.Selection;
import org.jetbrains.annotations.NotNull;

public class FlowNodeActions {
    private ActionGroup activityActions;
    private final FlowNodeController controller;
    private FlowNode flowNode;

    private FlowNodeActions(@NotNull FlowNodeController controller) {
        this.controller = controller;
        this.flowNode = controller.getModelObject();
        this.activityActions = new ActionGroup(ProjectMsg.ACTIVITIES);
    }

    public static ActionGroup build(@NotNull FlowNodeController controller) {
        FlowNodeActions actions = new FlowNodeActions(controller);
        return actions.buildActions();
    }

    public static ActionGroup buildTransitionTargetAction(@NotNull FlowNode source, @NotNull TransitionType transitionType) {
        ActionGroup result;
        NodeContainer container = source.getParentObject();
        ActionGroup currentAction = result = new ActionGroup(transitionType.getMsgForNewTo());
        if (!FlowNodeActions.checkValidTargets(source, transitionType)) {
            return null;
        }
        TreeMap<String, FlowNode> sorted = new TreeMap<String, FlowNode>();
        for (FlowNode flowNode : container.getFlowNodes()) {
            sorted.put(ModelUtils.getDuplicatedLabel((FlowNode)flowNode), flowNode);
        }
        Iterator iterator = sorted.values().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            FlowNode target = (FlowNode)iterator.next();
            try {
                SequenceFlowPolicies.checkSequenceFlow((FlowNode)source, (FlowNode)target, (boolean)transitionType.isConditional());
            }
            catch (ProjectException e) {
                continue;
            }
            if (i >= 10) {
                ActionGroup moreActions = new ActionGroup(DesignerMsg.MORE);
                currentAction.addSeparator();
                currentAction.add((BaseAction)moreActions);
                currentAction = moreActions;
                i = 0;
            }
            currentAction.add((BaseAction)new AddTransitionToMenuAction(source, target, transitionType));
            ++i;
        }
        return result;
    }

    public static boolean checkValidTargets(FlowNode sourceNode, TransitionType transitionType) {
        boolean result = false;
        Sequence flowNodes = FlowNodeActions.getNodeContainer(sourceNode).getFlowNodes();
        for (FlowNode targetNode : flowNodes) {
            try {
                SequenceFlowPolicies.checkSequenceFlow((FlowNode)sourceNode, (FlowNode)targetNode, (boolean)transitionType.isConditional());
            }
            catch (ProjectException e) {
                continue;
            }
            result = true;
            break;
        }
        return result;
    }

    public ActionGroup buildActions() {
        this.addTransitionActions();
        this.addGoToAction();
        ActionGroup result = this.getActivityActions();
        result.setSelection(DefaultSelection.createSingle((Object)ModelObjectSelection.create((FlowElement[])new FlowElement[]{this.getFlowNode()})));
        return result;
    }

    private static NodeContainer getNodeContainer(@NotNull FlowNode flowNode) {
        return flowNode.getParentObject();
    }

    private FlowNode getFlowNode() {
        return this.flowNode;
    }

    private ActionGroup getActivityActions() {
        return this.activityActions;
    }

    private FlowNodeController getController() {
        return this.controller;
    }

    private void addTransitionsActionForType(ActionGroup composed, TransitionType transitionType) {
        if (!DesignerMode.isValid(transitionType)) {
            return;
        }
        StartAddingTransition action = new StartAddingTransition(this.getController(), transitionType);
        action.setSmallIcon(DesignerPreferences.getPreferences().getTheme().getImageFor(transitionType));
        composed.add((BaseAction)action);
    }

    private void addTransitionActions() {
        ActionGroup actionGroup = this.getActivityActions();
        FlowNode flowNode = this.getFlowNode();
        boolean isDiverging = false;
        if (flowNode.isGateway()) {
            NodeAssociationFeature associationFeature;
            Gateway gateway = (Gateway)flowNode.asAnyNode(Gateway.class);
            boolean bl = isDiverging = gateway.getDirection() == GatewayDirection.DIVERGING;
            if (isDiverging && gateway.getBpmnType() == BpmnType.PARALLEL_GATEWAY && (associationFeature = (NodeAssociationFeature)flowNode.getFeature(NodeAssociationFeature.class)) != null) {
                FlowNode associatedNode = associationFeature.getAssociatedNode();
                AddTransitionAction transitionAction = new AddTransitionAction(flowNode.getProcess(), flowNode, associatedNode, TransitionType.UNCONDITIONAL, DesignerMsg.ADD_THREAD);
                actionGroup.add((BaseAction)transitionAction);
            }
        }
        actionGroup.addSeparator();
        if (ModelUtils.getOutgoingUnconditionalSequenceFlows((FlowNode)flowNode).isEmpty() && ModelUtils.shouldHaveOutgoingSequenceFlow((FlowNode)flowNode) || ModelUtils.isEventBasedGateway((FlowNode)flowNode) || flowNode.getBpmnType() == BpmnType.PARALLEL_GATEWAY && isDiverging) {
            this.addTransitionsActionForType(actionGroup, TransitionType.UNCONDITIONAL);
        }
        if (ModelUtils.canHaveOutgoingConditionalFlows((FlowNode)flowNode) && FlowNodeActions.checkValidTargets(flowNode, TransitionType.CONDITIONAL)) {
            this.addTransitionsActionForType(actionGroup, TransitionType.CONDITIONAL);
        }
    }

    private void addGoToAction() {
        ActionGroup actionGroup = this.getActivityActions();
        FlowNode flowNode = this.getFlowNode();
        if (((ActivityImpl)flowNode).isCallActivity()) {
            CallActivity callActivity = (CallActivity)flowNode.asAnyNode(CallActivity.class);
            final Process calledElement = callActivity.getCalledElement();
            BaseAction editProcess = new BaseAction(DesignerMsg.GOTO_PROCESS, CallActivity.class){

                public void run() {
                    AbstractStudioWorkbench.getInstance().openEditorForObject(calledElement);
                }

                protected void updateEnableStatus(Selection s) {
                    super.updateEnableStatus(s);
                    this.setEnabled(calledElement != null);
                }
            };
            if (editProcess.isEnabled() && calledElement != null) {
                editProcess.setSmallIcon(ProjectObjectRenderer.Default.getIcon((ProjectObject)calledElement));
            }
            actionGroup.add(editProcess);
        }
        actionGroup.addSeparator();
    }

    private static final class StartAddingTransition
    extends DesignerAction {
        private final FlowNodeController controller;
        private final TransitionType transitionType;

        public StartAddingTransition(@NotNull FlowNodeController controller, @NotNull TransitionType transitionType) {
            super(transitionType.getMsgForNew());
            this.controller = controller;
            this.transitionType = transitionType;
            this.requires(FlowNode.class);
        }

        @Override
        public void run() {
            AddingSequenceFlowState state = AddingSequenceFlowState.create(this.controller.getContainer(), this.controller.getModelObject(), this.transitionType);
            this.controller.getDomain().setCurrentTool((AbstractDesignerState)state);
        }
    }

    private static class AddTransitionToMenuAction
    extends DesignerAction {
        private final FlowNode sourceNode;
        private final FlowNode targetNode;
        private final TransitionType transitionType;

        public AddTransitionToMenuAction(FlowNode sourceNode, FlowNode targetNode, TransitionType transitionType) {
            super(DesignerMsg.ADD_TRANSITION);
            this.sourceNode = sourceNode;
            this.targetNode = targetNode;
            this.transitionType = transitionType;
            this.requires(Activity.class);
            this.requires(Process.class);
            DefaultTheme theme = DesignerPreferences.getPreferences().getTheme();
            this.setSmallIcon(theme.getImageFor((FlowElement)targetNode, ImageType.ICON));
            this.setMsg(DesignerMsg.EMPTY_MSG(ModelUtils.getDuplicatedLabel((FlowNode)targetNode)));
        }

        @Override
        public void run() {
            new AddTransitionAction(this.targetNode.getProcess(), this.sourceNode, this.targetNode, this.transitionType).run();
        }
    }
}

