/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.AbstractTreeNode;
import oracle.bpm.designer.FindComponentDialog;
import oracle.bpm.designer.ProjectNavigatorTree;
import oracle.bpm.designer.ProjectTreeNode;
import oracle.bpm.designer.action.ModuleAction;
import oracle.bpm.designer.action.OpenCatalogNodeAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.project.model.Project;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.selection.Selection;

public class FindComponentAction
extends ModuleAction {
    private Project project;

    public FindComponentAction() {
        super(DesignerMsg.FIND_COMPONENT);
        this.setShowOnDisabled(false);
        this.requires(Project.class);
        this.requires(ObjectTypeDescription.class);
    }

    public FindComponentAction(Project project) {
        this();
        this.project = project;
    }

    @Override
    public void run() {
        this.setSuccess(this.findComponent());
    }

    @Override
    protected void updateEnableStatus(Selection s) {
        Project p = (Project)s.as(Project.class);
        this.setEnabled(p != null && p.isOpen());
    }

    private boolean findComponent() {
        TypeRef typeRef;
        Project currentProject = this.project == null ? (Project)this.getSelection().as(Project.class) : this.project;
        FindComponentDialog findComponentDialog = new FindComponentDialog(Ui.getRoot(), currentProject);
        findComponentDialog.setVisible(true);
        boolean result = false;
        if (findComponentDialog.userAccepted() && (typeRef = findComponentDialog.getSelectedType()) != null) {
            AbstractTreeNode node;
            ProjectTreeNode projectTree = ProjectNavigatorTree.getTreeNodeFor(currentProject);
            if (projectTree != null && (node = projectTree.getCatalogNode().findQualifiedChild(typeRef.getText())) != null) {
                node.select();
            }
            OpenCatalogNodeAction nodeAction = new OpenCatalogNodeAction();
            nodeAction.runWithSelection(typeRef.get().asObject());
            result = nodeAction.isSuccess();
        }
        return result;
    }
}

