/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.ListModel;
import oracle.bpm.bpmobject.importexport.BusinessObjectExporter;
import oracle.bpm.bpmobject.importexport.ImportExportException;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.ProjectNavigatorTree;
import oracle.bpm.designer.action.ProjectMultipleActionElement;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.view.filter.ProjectFilters;
import oracle.bpm.project.view.project.view.renderer.ProjectObjectRenderer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ComponentBuilder;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.ListListModel;
import oracle.bpm.ui.ListSelectionMode;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.TreeSelectionMode;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.event.TreeSelectionEvent;
import oracle.bpm.ui.event.TreeSelectionListener;
import oracle.bpm.ui.filechooser.FileChooser;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.ui.tree.TreeNode;
import oracle.bpm.util.FileFilter;

public class ExportObjectAction
extends DesignerAction
implements ProjectMultipleActionElement {
    private File destinationDir;
    private String fileName;
    private static final String DEFAULT_EXPORT_FILE = "BPMOExport";
    public static final String BOB_EXTENSION = ".bob";

    private ExportObjectAction(Msg actionMsg) {
        super(actionMsg);
        this.requires(ObjectTypeDescription.class);
        this.setShowOnDisabled(false);
    }

    public static ExportObjectAction createSingleAction() {
        return new ExportObjectAction(DesignerMsg.EXPORT_BOBJECT);
    }

    public static ExportObjectAction createMultipleAction() {
        return new ExportObjectAction(DesignerMsg.EXPORT_BOBJECTS);
    }

    @Override
    public void setDestinationDir(File f) {
        this.destinationDir = f;
    }

    @Override
    public void run() {
        this.exportObject();
    }

    protected void updateEnableStatus(Selection selection) {
        CatalogObject objectType = (CatalogObject)selection.as(CatalogObject.class);
        boolean isRoot = objectType.getParentObject() == null;
        boolean isModule = objectType.isModule();
        this.setEnabled(isRoot || isModule || !objectType.isInnerType() && objectType.isBpmObject());
    }

    private File getDestinationFile(File destinationDir) {
        return new File(destinationDir + File.separator + (this.fileName == null ? DEFAULT_EXPORT_FILE : this.fileName) + BOB_EXTENSION);
    }

    private FileChooser buildFileChooser() {
        FileChooser chooser = new FileChooser();
        chooser.setName("export.object");
        return chooser;
    }

    private boolean exportObject() {
        boolean result;
        this.fileName = null;
        CatalogObject selected = this.getSelectedObject();
        if (selected != null && selected.isBpmObject()) {
            this.fileName = selected.getText();
            result = this.export(Collections.singleton(selected));
        } else {
            ArrayList<CatalogObject> selection;
            result = selected != null ? (selection = this.chooseObjects(selected)) != null && this.export(selection) : false;
        }
        return result;
    }

    private CatalogObject getSelectedObject() {
        return (CatalogObject)this.getSelection().as(CatalogObject.class);
    }

    private Project getProject() {
        CatalogObject objectType = this.getSelectedObject();
        return objectType.getProject();
    }

    private ArrayList<CatalogObject> chooseObjects(final CatalogObject selected) {
        final Project project = this.getProject();
        final ArrayList<CatalogObject> objectTypeDescriptionArrayList = new ArrayList<CatalogObject>();
        ComponentBuilder builder = new ComponentBuilder(){
            public Panel container;

            public UiComponent getComponent() {
                return this.container;
            }

            public UiComponent buildComponent(UiContainer parent) {
                MigLayout mig = new MigLayout("ins 10,gap 5,fill");
                this.container = new Panel(parent);
                this.container.setLayout((Layout)mig);
                final ProjectNavigatorTree navigatorTree = new ProjectNavigatorTree((UiContainer)this.container, (ProjectObject)project.getCatalogRoot(), ProjectFilters.BUSINESS_OBJECTS_AND_MODULES, true);
                navigatorTree.setSelectionMode(TreeSelectionMode.DISCONTIGUOUS_TREE_SELECTION);
                navigatorTree.setShowMenues(false);
                navigatorTree.setPopupEnabled(false);
                if (selected != null) {
                    TreeNode node = navigatorTree.findNode((ProjectObject)selected);
                    node.expand();
                    node.select();
                }
                Panel resultList = new Panel((UiContainer)this.container);
                final XObjectListModel model = new XObjectListModel(objectTypeDescriptionArrayList);
                final oracle.bpm.ui.List list = new oracle.bpm.ui.List((UiContainer)resultList, (ListModel)((Object)model), ListSelectionMode.MULTIPLE_INTERVAL_SELECTION);
                list.setLabelProvider((LabelProvider)new LabelProvider<CatalogObject>(){

                    public Image getIcon(CatalogObject element) {
                        return ProjectObjectRenderer.Default.getIcon((ProjectObject)element);
                    }

                    public String getText(CatalogObject element) {
                        return element.getText();
                    }
                });
                Panel toolbar = new Panel((UiContainer)this.container);
                FormLayout form = new FormLayout("2dlu:grow(0.5), pref,2dlu:grow(0.5)", "2dlu:grow(0.5),pref,2dlu,pref,2dlu:grow(0.5)");
                toolbar.setLayout((Layout)form);
                CellConstraints cc = form.createCellConstraints();
                final Button addButton = new Button((UiContainer)toolbar);
                addButton.setIcon(DesignerMsg.SHUTTLE_RIGHT);
                addButton.addActionListener((ActionListener)new MoveAction(true, navigatorTree, (oracle.bpm.ui.List<CatalogObject>)list, model));
                addButton.setEnabled(false);
                final Button removeButton = new Button((UiContainer)toolbar);
                removeButton.setIcon(DesignerMsg.SHUTTLE_LEFT);
                removeButton.setEnabled(false);
                removeButton.addActionListener((ActionListener)new MoveAction(false, navigatorTree, (oracle.bpm.ui.List<CatalogObject>)list, model));
                toolbar.add((UiComponent)addButton, (Object)cc.xy(2, 2));
                toolbar.add((UiComponent)removeButton, (Object)cc.xy(2, 4));
                navigatorTree.addTreeSelectionListener(new TreeSelectionListener(){

                    public void valueChanged(TreeSelectionEvent e) {
                        TreeNode[] nodes = navigatorTree.getSelectedTreeNodes();
                        boolean enabled = false;
                        if (nodes != null) {
                            for (TreeNode node : nodes) {
                                CatalogObject xo = (CatalogObject)node.as(CatalogObject.class);
                                if (xo == null || !xo.isBpmObject() || model.contains(xo)) continue;
                                enabled = true;
                                break;
                            }
                        }
                        addButton.setEnabled(enabled);
                    }
                });
                list.addListSelectionListener(new ListSelectionListener(){

                    public void valueChanged(ListSelectionEvent e) {
                        List selectedValues = list.getSelectedValues();
                        removeButton.setEnabled(selectedValues != null && selectedValues.size() > 0);
                    }
                });
                this.container.add((UiComponent)Label.create((UiContainer)this.container, (Msg)DesignerMsg.CHOOSE_BPMOBJECTS), (Object)"spanx,growx,wrap");
                this.container.add((UiComponent)navigatorTree, (Object)"growx,growy,sg list");
                this.container.add((UiComponent)toolbar, (Object)"growy");
                this.container.add((UiComponent)list, (Object)"growx,growy,sg list,wrap");
                return this.container;
            }

            public boolean validate() {
                boolean result;
                boolean bl = result = !objectTypeDescriptionArrayList.isEmpty();
                if (!result) {
                    MessageDialog.showError((Msg)DesignerMsg.EXPORT_BOBJECTS, (Msg)DesignerMsg.DYNAMIC_AT_LEAST_ONE_SELECTED(DesignerMsg.OBJECT));
                }
                return result;
            }
        };
        if (OkCancelDialog.showComponent((UiWindow)Ui.getRoot(), (ComponentBuilder)builder, (Msg)DesignerMsg.EXPORT_BOBJECTS)) {
            return objectTypeDescriptionArrayList;
        }
        return null;
    }

    private boolean export(Collection<CatalogObject> objects) {
        int res;
        File selectedFile;
        if (this.destinationDir == null) {
            FileChooser chooser = this.buildFileChooser();
            FileFilter filter = FileFilter.create(UIMsg.EXPORTED_FILE_NAME, BOB_EXTENSION);
            chooser.setFileFilter(filter);
            chooser.setSelectedFile(this.getDestinationFile(chooser.getCurrentDirectory()));
            int returnVal = chooser.showSaveDialog((UiComponent)Ui.getRoot(), DesignerMsg.SELECT_EXPORTED_FILE_NAME);
            selectedFile = chooser.getSelectedFile();
            if (selectedFile == null || returnVal != 0) {
                return false;
            }
        } else {
            selectedFile = this.getDestinationFile(this.destinationDir);
        }
        if (!selectedFile.exists() && selectedFile.getPath().toLowerCase().lastIndexOf(BOB_EXTENSION) == -1) {
            selectedFile = new File(selectedFile.getPath() + BOB_EXTENSION);
        }
        if (selectedFile.exists() && (res = MessageDialog.showQuestion((Msg)CoreMsg.WARNING, (Msg)DesignerMsg.FILE_EXISTS_SAVE_ANYWAY, (int)9)) != 1) {
            return false;
        }
        boolean exportFinish = false;
        BusinessObjectExporter exporter = new BusinessObjectExporter();
        HashSet<XObjectTypeDescription> set = new HashSet<XObjectTypeDescription>();
        for (CatalogObject catalogObject : objects) {
            ObjectTypeDescription otd = catalogObject.getObjectType();
            if (!otd.isBpmObject()) continue;
            set.add((XObjectTypeDescription)otd);
        }
        try {
            exporter.export(set, selectedFile);
            exportFinish = false;
        }
        catch (ImportExportException e) {
            MessageDialog.showError((Throwable)e);
        }
        return exportFinish;
    }

    private static class XObjectListModel
    extends ListListModel<CatalogObject> {
        public XObjectListModel(List<CatalogObject> xObjectTypeDescriptions) {
            super(xObjectTypeDescriptions);
        }

        public void addXObject(CatalogObject xo) {
            if (!this.contains(xo)) {
                this.getDelegate().add(xo);
                this.fireContentsChanged((Object)this, this.getSize() - 1, this.getSize());
            }
        }

        public boolean contains(CatalogObject xo) {
            return this.getDelegate().contains(xo);
        }

        public void remove(CatalogObject xo) {
            int index = this.getDelegate().indexOf(xo);
            this.getDelegate().remove(xo);
            this.fireContentsChanged((Object)this, index, this.getSize());
        }
    }

    private static class MoveAction
    extends BaseAction {
        private boolean add;
        private XObjectListModel data;
        private oracle.bpm.ui.List<CatalogObject> list;
        private ProjectNavigatorTree navigatorTree;

        public MoveAction(boolean add, ProjectNavigatorTree navigatorTree, oracle.bpm.ui.List<CatalogObject> list, XObjectListModel data) {
            super(Msg.QUOTE(add ? ">>" : "<<"));
            this.add = add;
            this.navigatorTree = navigatorTree;
            this.list = list;
            this.data = data;
        }

        public void run() {
            if (this.add) {
                TreeNode[] multipleSelection;
                for (TreeNode selection : multipleSelection = this.navigatorTree.getSelectedTreeNodes()) {
                    CatalogObject xo = (CatalogObject)selection.as(CatalogObject.class);
                    if (!xo.isBpmObject() || this.data.contains(xo)) continue;
                    this.data.addXObject(xo);
                }
            } else {
                List values = this.list.getSelectedValues();
                for (CatalogObject catalogObject : values) {
                    this.data.remove(catalogObject);
                }
                this.list.clearSelection();
            }
        }
    }
}

