/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.configuration.ConfigType;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.ObjectContainerDialog;
import oracle.bpm.designer.action.OpenObjectAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogModule;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.xobject.lib.XObjectTypeDescriptionHelper;

public class EncapsulateObjectAction
extends DesignerAction {
    private final Project project;
    private ObjectTypeDescription type;
    public static final String BPM_OBJECT_PREFIX = "BusinessObject";

    public EncapsulateObjectAction(Project project, ObjectTypeDescription otd) {
        super(DesignerMsg.ENCAPSULATE_OBJECT);
        this.project = project;
        this.type = otd;
        this.requires(ObjectTypeDescription.class);
        this.setShowOnDisabled(false);
    }

    @Override
    public boolean doIt() {
        try {
            return this.createXObject();
        }
        catch (ProjectException e) {
            return false;
        }
    }

    public void unDoIt() {
    }

    protected void updateEnableStatus(Selection selection) {
        ObjectTypeDescription objectType = (ObjectTypeDescription)selection.as(ObjectTypeDescription.class);
        ConfigType componentType = ConfigType.find(objectType.getComponentType());
        this.setEnabled(objectType.hasDefaultInit() && !objectType.isEnum() && !objectType.isRemote() && (componentType == null || componentType.supportHeirs()));
    }

    private boolean createXObject() throws ProjectException {
        CatalogObject objectTypeDescription = (CatalogObject)this.getSelection().as(CatalogObject.class);
        CatalogObject module = this.getModule(objectTypeDescription);
        ObjectContainerDialog dialog = new ObjectContainerDialog(Ui.getRoot(), DesignerMsg.NEW_BPMOBJECT, DesignerMsg.ENCAPSULATE_OBJECT_NAME(this.type.getName()), BPM_OBJECT_PREFIX, module, this.project);
        ComponentCatalog repository = this.type.getCatalog();
        dialog.setTypeRepository(repository);
        dialog.setVisible(true);
        if (dialog.userAccepted()) {
            CatalogModule parent = dialog.getParentModule();
            String name = dialog.getObjectName();
            CatalogObject newType = CatalogObjectImpl.create((TypeRef)XObjectTypeDescriptionHelper.encapsulate((String)name, (ObjectTypeDescription)this.type));
            parent.asMutable().addChild((ProjectObject)newType);
            new OpenObjectAction(newType).run();
            return true;
        }
        return false;
    }

    private CatalogObject getModule(CatalogObject objectTypeDescription) {
        ObjectTypeDescription parent = objectTypeDescription.getObjectType().getParent().asObject();
        if (parent == null || parent.isModule()) {
            return CatalogObjectImpl.create((TypeRef)parent);
        }
        return this.getModule(CatalogObjectImpl.create((TypeRef)parent));
    }
}

