/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import java.util.Collection;
import oracle.bpm.command.Command;
import oracle.bpm.designer.Clipboard;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.command.PasteCopiedObjectsCommand;
import oracle.bpm.geom.Point;
import oracle.bpm.project.model.Transactable;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.ui.selection.SelectionListener;

public class DesignerPasteAction
extends DesignerAction {
    private Point targetLocation;
    private static DesignerPasteAction instance;

    private DesignerPasteAction() {
        super(UIMsg.PASTE);
        this.requires(Process.class);
    }

    public static DesignerPasteAction getInstance() {
        if (instance == null) {
            instance = new DesignerPasteAction();
        }
        return instance;
    }

    @Override
    public void run() {
        Selection currentSelection = this.getSelection();
        if (currentSelection != null) {
            Process targetProcess = (Process)currentSelection.as(Process.class);
            Collection<FlowElement> positionals = Clipboard.getInstance().getObjects();
            if (positionals != null && !positionals.isEmpty()) {
                ((Transactable)targetProcess).beginTransaction();
                this.getRunner().run((Command)((Object)new PasteCopiedObjectsCommand(targetProcess, this.targetLocation == null ? new Point(30, 30) : this.targetLocation)));
                ((Transactable)targetProcess).endTransaction();
            }
        }
    }

    public void setTargetLocation(Point targetLocation) {
        this.targetLocation = targetLocation;
    }

    public static class ContextualDesignerPasteAction
    extends DesignerPasteAction
    implements SelectionListener,
    Clipboard.ClipboardListener {
        private static ContextualDesignerPasteAction contextualInstance;

        private ContextualDesignerPasteAction() {
            Clipboard.getInstance().addClipboardListener(this);
        }

        public static ContextualDesignerPasteAction getInstance() {
            if (contextualInstance == null) {
                contextualInstance = new ContextualDesignerPasteAction();
            }
            return contextualInstance;
        }

        public void selectionChanged(Selection sel) {
            this.setSelection(sel);
        }

        @Override
        public void clipboardChanged() {
            this.updateEnableStatus(null);
        }

        protected void updateEnableStatus(Selection sel) {
            this.setEnabled(Clipboard.getInstance().canPaste());
        }
    }
}

