/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.command.Command;
import oracle.bpm.designer.Context;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.ProcessDomain;
import oracle.bpm.designer.command.RemoveObjectsCommand;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.ui.ModelObjectSelection;
import oracle.bpm.ui.ActionOrder;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.selection.Selection;
import org.jetbrains.annotations.NotNull;

public class DesignerDeleteAction
extends DesignerAction {
    private static DesignerDeleteAction instance;

    private DesignerDeleteAction() {
        super(UIMsg.MENU_DELETE);
        this.setOrder(ActionOrder.LAST);
        this.requires(Void.class);
    }

    public static DesignerDeleteAction getInstance() {
        if (instance == null) {
            instance = new DesignerDeleteAction();
        }
        return instance;
    }

    @Override
    public void run() {
        Selection selection = this.getSelection();
        if (selection != null) {
            try {
                FlowElement element;
                ModelObjectSelection mos = (ModelObjectSelection)selection.as(ModelObjectSelection.class);
                if (mos == null && (element = (FlowElement)selection.as(FlowElement.class)) != null) {
                    mos = ModelObjectSelection.create((FlowElement[])new FlowElement[]{element});
                }
                if (mos != null) {
                    this.getRunner().run((Command)((Object)new RemoveObjectsCommand(mos)));
                    this.clearSelection(mos);
                }
            }
            catch (Exception e) {
                MessageDialog.showError((Throwable)e);
            }
        }
    }

    protected void updateEnableStatus(@NotNull Selection selection) {
        boolean result;
        boolean bl = result = selection.as(ModelObjectSelection.class) != null;
        if (!result) {
            FlowElement flowElement = (FlowElement)selection.as(FlowElement.class);
            result = flowElement != null && (!flowElement.is(FlowNode.class) || ModelUtils.isAnyJoin((FlowNode)((FlowNode)flowElement)));
        }
        this.setEnabled(result);
    }

    private void clearSelection(@NotNull ModelObjectSelection selection) {
        ProcessDomain domain;
        Process process = (Process)selection.as(Process.class);
        if (process != null && (domain = Context.getDomainFor(process)) != null) {
            domain.getSelectionProvider().clear();
        }
    }
}

