/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import java.util.Collection;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.command.Command;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.action.DesignerCopyAction;
import oracle.bpm.designer.command.RemoveObjectsCommand;
import oracle.bpm.project.command.design.CopyPasteHelper;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.ui.ModelObjectSelection;
import oracle.bpm.ui.ActionOrder;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.ui.selection.SelectionListener;
import org.jetbrains.annotations.Nullable;

public class DesignerCutAction
extends DesignerAction {
    private static DesignerCutAction instance;

    private DesignerCutAction() {
        super(UIMsg.CUT);
        this.setOrder(ActionOrder.BOTTOM);
        this.requires(ModelObjectSelection.class);
        this.setShowOnDisabled(false);
    }

    public static DesignerCutAction getInstance() {
        if (instance == null) {
            instance = new DesignerCutAction();
        }
        return instance;
    }

    @Override
    public void run() {
        ModelObjectSelection selectedObjects = (ModelObjectSelection)this.getSelection().as(ModelObjectSelection.class);
        if (selectedObjects != null) {
            DesignerCopyAction designerCopyAction = DesignerCopyAction.getInstance();
            designerCopyAction.setSelection((Selection)selectedObjects);
            designerCopyAction.run();
            this.getRunner().run((Command)((Object)new RemoveObjectsCommand(CopyPasteHelper.normalizeForCut((Collection)selectedObjects.getObjects()))));
        }
    }

    protected void updateEnableStatus(Selection s) {
        Collection flowElements = CopyPasteHelper.normalizeForCut((Collection)((ModelObjectSelection)s.as(ModelObjectSelection.class)).getObjects());
        this.setEnabled(!flowElements.isEmpty() && !CollectionUtils.asSequence(flowElements).select(new Predicate<FlowElement>(){

            @Override
            public boolean check(@Nullable FlowElement value) {
                return ModelUtils.canDelete((FlowElement)value);
            }
        }).isEmpty());
    }

    public static class ContextualDesignerCutAction
    extends DesignerCutAction
    implements SelectionListener {
        private static ContextualDesignerCutAction contextualInstance;

        private ContextualDesignerCutAction() {
        }

        public static ContextualDesignerCutAction getInstance() {
            if (contextualInstance == null) {
                contextualInstance = new ContextualDesignerCutAction();
            }
            return contextualInstance;
        }

        public void selectionChanged(Selection sel) {
            this.setSelection(sel);
        }

        @Override
        protected void updateEnableStatus(Selection sel) {
            ModelObjectSelection finalSelection = (ModelObjectSelection)sel.as(ModelObjectSelection.class);
            this.setEnabled(finalSelection != null && !finalSelection.isEmpty());
        }
    }
}

