/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import java.util.Collection;
import oracle.bpm.command.Command;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.command.CopyObjectsCommand;
import oracle.bpm.project.command.design.CopyPasteHelper;
import oracle.bpm.project.ui.ModelObjectSelection;
import oracle.bpm.ui.ActionOrder;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.ui.selection.SelectionListener;

public class DesignerCopyAction
extends DesignerAction {
    private static DesignerCopyAction instance;

    private DesignerCopyAction() {
        super(UIMsg.COPY);
        this.setOrder(ActionOrder.BOTTOM);
        this.requires(ModelObjectSelection.class);
        this.setShowOnDisabled(false);
    }

    public static DesignerCopyAction getInstance() {
        if (instance == null) {
            instance = new DesignerCopyAction();
        }
        return instance;
    }

    @Override
    public void run() {
        Selection selection = this.getSelection();
        if (selection != null) {
            ModelObjectSelection processSelection = (ModelObjectSelection)selection.as(ModelObjectSelection.class);
            this.getRunner().run((Command)((Object)new CopyObjectsCommand(CopyPasteHelper.normalizeForCopy((Collection)processSelection.getObjects()))));
        }
    }

    protected void updateEnableStatus(Selection s) {
        ModelObjectSelection modelObjectSelection = (ModelObjectSelection)s.as(ModelObjectSelection.class);
        this.setEnabled(!CopyPasteHelper.normalizeForCopy((Collection)modelObjectSelection.getObjects()).isEmpty());
    }

    public static class ContextualDesignerCopyAction
    extends DesignerCopyAction
    implements SelectionListener {
        private static ContextualDesignerCopyAction contextualInstance;

        private ContextualDesignerCopyAction() {
        }

        public static ContextualDesignerCopyAction getInstance() {
            if (contextualInstance == null) {
                contextualInstance = new ContextualDesignerCopyAction();
            }
            return contextualInstance;
        }

        public void selectionChanged(Selection selection) {
            this.setSelection(selection);
        }

        @Override
        protected void updateEnableStatus(Selection selection) {
            ModelObjectSelection finalSelection = (ModelObjectSelection)selection.as(ModelObjectSelection.class);
            this.setEnabled(finalSelection != null && !finalSelection.isEmpty());
        }
    }
}

