/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.action.DeleteObjectAction;
import oracle.bpm.log.Log;
import oracle.bpm.project.io.sensor.MeasurementsFileGenerator;
import oracle.bpm.project.io.serializers.model.documentation.DocumentationFileGenerator;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;

public class DeleteProcessAction
extends DeleteObjectAction {
    private Process process;

    public DeleteProcessAction(Process process) {
        super((ProjectObject)process);
        this.process = process;
    }

    public DeleteProcessAction(Process process, String detail) {
        super((ProjectObject)process, detail);
    }

    @Override
    protected String getObjectName() {
        return this.process.getDefaultLabel();
    }

    @Override
    protected Object delete(ProjectObject projectObject) {
        assert (projectObject instanceof Process) : "projectObject must be instance of Process";
        Process process = (Process)projectObject;
        this.deleteSimulationModelsFor(process);
        this.deleteDocumentationFileFor(process);
        this.updateMeasurementsFor(process);
        return super.delete((ProjectObject)process);
    }

    private void deleteSimulationModelsFor(Process process) {
        try {
            process.getProject().getSimulations().removeAllModelSimulations(process.getId());
        }
        catch (ProjectException e) {
            Log.logSevere(e);
        }
    }

    private void updateMeasurementsFor(Process process) {
        MeasurementsFileGenerator fileGenerator = new MeasurementsFileGenerator(process.getProject());
        fileGenerator.generateFile();
    }

    private void deleteDocumentationFileFor(Process process) {
        try {
            DocumentationFileGenerator.deleteDocumentationFileFor((Process)process);
        }
        catch (ProjectException e) {
            Log.logSevere(e);
        }
    }
}

