/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.exception.CouldNotDeleteResourceException;
import oracle.bpm.lang.exception.ReadOnlyException;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.ReadOnlyCatalogException;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.DialogFactory;
import oracle.bpm.ui.HiddenMessagesPreferences;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.selection.Selection;

@Deprecated
public class DeleteCatalogNodeAction
extends DesignerAction {
    boolean force;
    TypeRef ref;
    boolean showProgress = true;
    ObjectTypeDescription type;

    public DeleteCatalogNodeAction(ObjectTypeDescription otd) {
        this(otd, false);
    }

    public DeleteCatalogNodeAction(ObjectTypeDescription otd, boolean force) {
        this((TypeRef)otd, force, false);
        this.type = otd;
    }

    public DeleteCatalogNodeAction(ObjectTypeDescription otd, boolean force, boolean showProgress) {
        this(otd, force);
        this.showProgress = showProgress;
    }

    public DeleteCatalogNodeAction(TypeRef ref, boolean force, boolean showProgress) {
        super(UIMsg.MENU_DELETE);
        this.ref = ref;
        this.force = force;
        this.showProgress = showProgress;
        this.requires(ObjectTypeDescription.class);
    }

    public boolean delete() {
        if (this.canDelete()) {
            String text = this.type.getText();
            ObjectTypeDescription parent = (ObjectTypeDescription)this.type.getParent();
            try {
                this.performRemove(text, parent);
                return true;
            }
            catch (CouldNotDeleteResourceException e) {
                MessageDialog.showError((Msg)e.getMsg());
            }
            catch (ReadOnlyCatalogException e) {
                throw new ReadOnlyException(e.getMsg());
            }
            catch (Exception e) {
                MessageDialog.showError((Throwable)e);
            }
        }
        return false;
    }

    @Override
    public boolean doIt() {
        if (this.ref != null) {
            this.type = this.ref.get().asObject();
        }
        return this.delete();
    }

    public void unDoIt() {
    }

    protected void updateEnableStatus(Selection selection) {
        CatalogObject catalogObject = (CatalogObject)selection.as(CatalogObject.class);
        ObjectTypeDescription objectType = catalogObject.getObjectType();
        this.setEnabled(!catalogObject.isReadOnly() && !objectType.isInnerType() && objectType.getParentRef() != null);
    }

    private Project getProject(TypeRef ref) {
        return FuegoProject.getFrom((TypeRef)ref);
    }

    private boolean canDelete() {
        boolean result = !this.type.isDefault();
        result = result && this.type.getParent() != null;
        boolean bl = result = result && (!this.type.isBpmObject() || !this.type.getParent().isBpmObject());
        if (!this.force) {
            DesignerPreferences preferences = DesignerPreferences.getPreferences();
            result = result && DialogFactory.showConfirmDialog((HiddenMessagesPreferences)preferences, (Msg)UIMsg.MENU_DELETE, (Msg)DesignerMsg.CONFIRM_COMPONENT_DELETE);
            preferences.store();
        }
        return result;
    }

    private void performRemove(String qualifiedName, ObjectTypeDescription parent) throws TypeCatalogException {
        ComponentCatalog catalog = parent.getCatalog();
        MutableComponentCatalog repository = (MutableComponentCatalog)catalog;
        repository.remove(qualifiedName);
        parent.removeInnerType(this.type);
    }
}

