/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionEvent;

public class DelegateAction
extends BaseAction
implements PropertyChangeListener {
    private BaseAction innerAction;

    public DelegateAction(Msg msg) {
        this(msg, null);
    }

    public DelegateAction(Msg msg, BaseAction innerAction) {
        super(msg);
        this.setDelegateAction(innerAction);
        if (innerAction != null) {
            List requiredClasses = innerAction.getRequiredClasses();
            assert (!requiredClasses.isEmpty()) : "Action does not have required classes: " + innerAction;
            for (Class cl : requiredClasses) {
                this.requires(cl);
            }
        } else {
            this.requires(Void.class);
        }
    }

    public void setDelegateAction(BaseAction innerAction) {
        if (this.innerAction != null) {
            this.innerAction.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.innerAction = innerAction;
        if (innerAction != null) {
            this.setEnabled(innerAction.isEnabled());
            innerAction.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public BaseAction getDelegateAction() {
        return this.innerAction;
    }

    public void setEnabled(boolean newValue) {
        super.setEnabled(newValue);
    }

    public void actionPerformed(ActionEvent e) {
        BaseAction action = this.getDelegateAction();
        if (action != null) {
            action.actionPerformed(e == null ? null : e.asSwing());
        }
    }

    public void run() {
        BaseAction action = this.getDelegateAction();
        if (action != null) {
            action.run();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("enabled".equals(evt.getPropertyName())) {
            boolean newValue = (Boolean)evt.getNewValue();
            this.setEnabled(newValue);
        }
    }
}

