/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.CustomizeService;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.StudioWorkbench;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.ui.selection.Selection;

public class CustomizeServiceAction
extends DesignerAction {
    public CustomizeServiceAction() {
        super(DesignerMsg.CUSTOMIZE_SERVICE);
        this.requires(CatalogObject.class);
    }

    @Override
    public void run() {
        CatalogObject object = (CatalogObject)this.getSelection().as(CatalogObject.class);
        StudioWorkbench workbech = AbstractStudioWorkbench.getInstance();
        CustomizeService service = workbech.getCustomizeService();
        if (service != null) {
            if (object.getDelegate().isSynthesized()) {
                service.customizeService(object);
            } else {
                service.editCustomizedService(object);
            }
        }
    }

    protected void updateEnableStatus(Selection selection) {
        CatalogObject object = (CatalogObject)selection.as(CatalogObject.class);
        if (!object.isService()) {
            this.setEnabled(false);
        }
    }
}

