/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.ProjectNavigatorTree;
import oracle.bpm.designer.action.OpenObjectAction;
import oracle.bpm.designer.command.CopyProcessCommand;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.geom.Dimension;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.ui.msg.ProjectUiMsg;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ScrollPolicy;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.ui.text.TextField;
import org.jetbrains.annotations.NotNull;

public class CopyProcessAction
extends BaseAction {
    private Process process;
    private static BaseAction instance;

    private CopyProcessAction(Process process) {
        super(DesignerMsg.COPY_TO);
        this.requires(Process.class);
        this.process = process;
    }

    public static BaseAction create(@NotNull Process process) {
        return new CopyProcessAction(process);
    }

    public void run() {
        CopyProcessDialog dialog = new CopyProcessDialog();
        dialog.setVisible(true);
    }

    private Project getProject() {
        return this.process.getProject();
    }

    private class CopyProcessDialog
    extends OkCancelDialog {
        private TextArea descriptionField;
        private ProjectNavigatorTree locationTree;
        private TextField nameTextField;

        public CopyProcessDialog() {
            super(Ui.getRoot(), ProjectUiMsg.COPY((Msg)DesignerMsg.PROCESS), true);
            this.buildUi();
        }

        public void ok() {
            if (!this.validateValues()) {
                return;
            }
            this.setVisible(false);
            String processName = this.nameTextField.getText();
            FolderContainer location = this.locationTree != null ? (FolderContainer)this.locationTree.getSelectedNode().getUserObject() : CopyProcessAction.this.getProject().getModelsRoot();
            Object processCopy = new CopyProcessCommand(CopyProcessAction.this.process, location, processName, this.descriptionField.getText()).execute();
            OpenObjectAction open = new OpenObjectAction(processCopy);
            open.doIt();
        }

        private boolean validateValues() {
            if (Str.isEmpty(this.nameTextField.getText())) {
                MessageDialog.showError((Msg)DesignerMsg.PROCESS_NAME_CANNOT_BE_EMPTY);
                return false;
            }
            return true;
        }

        private void buildUi() {
            Panel parent = new Panel(this.getContentPane());
            parent.setLayout((Layout)new MigLayout("fill, gapy 10px"));
            String processName = ModelUtils.nextNameForModel((Project)CopyProcessAction.this.process.getProject(), (String)(DesignerMsg.COPY_OF.getString() + CopyProcessAction.this.process.getName()));
            this.nameTextField = new TextField((UiContainer)parent, processName);
            this.descriptionField = new TextArea((UiContainer)parent, ScrollPolicy.AS_NEEDED, ScrollPolicy.NEVER);
            this.descriptionField.setText(CopyProcessAction.this.process.getDefaultDescription());
            this.descriptionField.setRows(3);
            this.descriptionField.setPreferredSize(Dimension.valueOf(400, 50));
            parent.add((UiComponent)Label.create((UiContainer)parent, (Msg)DesignerMsg.NAME));
            parent.add((UiComponent)this.nameTextField, (Object)"growx, wrap");
            parent.add((UiComponent)Label.create((UiContainer)parent, (Msg)DesignerMsg.DESCRIPTION));
            parent.add((UiComponent)this.descriptionField, (Object)"grow, wrap");
            if (!CopyProcessAction.this.process.getProject().getModelsRoot().getChildrenByType(FolderContainer.class).isEmpty()) {
                this.locationTree = new ProjectNavigatorTree((UiContainer)parent, (ProjectObject)CopyProcessAction.this.process.getProject().getModelsRoot(), this.getLocationTreeFilter(), true);
                this.locationTree.getRoot().select();
                parent.add((UiComponent)Label.create((UiContainer)parent, (Msg)DesignerMsg.LOCATION));
                parent.add((UiComponent)this.locationTree, (Object)"growx");
            }
            this.getContentPane().add((UiComponent)parent);
            this.pack();
            this.setLocationRelativeTo((UiComponent)Ui.getRoot());
        }

        private ProjectFilter getLocationTreeFilter() {
            return new ProjectFilter(){

                @NotNull
                public Sequence<? extends ProjectObject> getChildren(ProjectObjectContainer object) {
                    return object.getChildrenByType(FolderContainer.class);
                }

                public ProjectObjectContainer getParent(ProjectObject object) {
                    return CopyProcessAction.this.process.getProject().getModelsRoot().equals(object) ? null : (ProjectObjectContainer)object.getParentObject();
                }
            };
        }
    }
}

