/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.CustomizeService;
import oracle.bpm.designer.StudioWorkbench;
import oracle.bpm.designer.action.CustomizeServiceAction;
import oracle.bpm.designer.action.CustomizeTypeAction;
import oracle.bpm.designer.action.ExportObjectAction;
import oracle.bpm.designer.action.ImportBPMObjectAction;
import oracle.bpm.designer.action.NewAttributeAction;
import oracle.bpm.designer.action.NewBpmObjectAction;
import oracle.bpm.designer.action.NewExceptionAction;
import oracle.bpm.designer.action.NewModuleAction;
import oracle.bpm.designer.action.ReloadCatalogAction;
import oracle.bpm.designer.action.SpringWsdlInterfaceAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogModule;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.BaseAction;

public class ComponentActions {
    private CatalogObject catalogObject;
    private Project project;

    public ComponentActions(Project project, CatalogObject catalogObject) {
        this.project = project;
        this.catalogObject = catalogObject;
    }

    public CatalogObject getCatalogObject() {
        return this.catalogObject;
    }

    public ActionGroup getActions() {
        ActionGroup actions = new ActionGroup(DesignerMsg.COMPONENT);
        CatalogObject catalogObject = this.getCatalogObject();
        boolean hasErrors = catalogObject.getDelegate().hasErrors();
        if (!hasErrors && !this.isCorruptedResource(catalogObject)) {
            if (catalogObject.isService() && !catalogObject.asInterfaceObject().isCallback()) {
                StudioWorkbench workbech = AbstractStudioWorkbench.getInstance();
                CustomizeService service = workbech.getCustomizeService();
                if (service != null) {
                    actions.add((BaseAction)new CustomizeServiceAction());
                }
            } else if (catalogObject.isBpmObject() && catalogObject.isSynthesized() && !catalogObject.isException()) {
                actions.add((BaseAction)new CustomizeTypeAction());
            }
            if (!catalogObject.isSynthesized()) {
                TypeDescription objectRef = catalogObject.getDelegate();
                ObjectTypeDescription objectType = objectRef.get().asObject();
                ActionGroup newActions = new ActionGroup(DesignerMsg.NEW);
                newActions.add((BaseAction)new NewAttributeAction(catalogObject));
                if (catalogObject.isModule()) {
                    CatalogModule module = catalogObject.asModule();
                    newActions.add(BaseAction.SEPARATOR);
                    newActions.add((BaseAction)new NewModuleAction(module));
                    newActions.add((BaseAction)new NewBpmObjectAction(module));
                    newActions.add((BaseAction)new NewExceptionAction(module));
                }
                actions.add((BaseAction)newActions);
                actions.add(BaseAction.SEPARATOR);
                if (!objectType.isBpmObject()) {
                    actions.add((BaseAction)new ReloadCatalogAction(catalogObject));
                    actions.add((BaseAction)ExportObjectAction.createMultipleAction());
                } else {
                    actions.add((BaseAction)ExportObjectAction.createSingleAction());
                }
                actions.add((BaseAction)new ImportBPMObjectAction(catalogObject));
                actions.add(BaseAction.SEPARATOR);
            }
        }
        if (catalogObject.isSpringService()) {
            actions.add((BaseAction)new SpringWsdlInterfaceAction());
        }
        return actions;
    }

    private boolean isCorruptedResource(CatalogObject catalogObject) {
        return catalogObject instanceof CatalogObjectImpl.CorruptedResourceImpl;
    }

    private Project getProject() {
        return this.project;
    }
}

