/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.action.BaseAction;

public class CloseProjectAction
extends DesignerAction {
    private BaseAction delegate;

    public CloseProjectAction() {
        this(true);
    }

    public CloseProjectAction(boolean ask) {
        super(DesignerMsg.CLOSE_PROJECT);
        this.requires(Project.class);
    }

    public void retarget(BaseAction delegate) {
        this.delegate = delegate;
    }

    @Override
    public void run() {
        if (this.delegate != null) {
            this.delegate.run();
        } else {
            this.close();
        }
    }

    private boolean close() {
        Project selectedProject = (Project)this.getSelection().as(Project.class);
        try {
            selectedProject.getRepository().close(selectedProject);
            return true;
        }
        catch (ProjectException e) {
            MessageDialog.showError((Throwable)e);
            return false;
        }
    }
}

