/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.action.AddObjectTypeDescriptionAction;
import oracle.bpm.designer.action.FuegoObjectAction;
import oracle.bpm.designer.action.OpenCatalogNodeAction;
import oracle.bpm.designer.catalog.BPMObjectNameInputValidator;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.navigator.ProjectNavigatorBuilder;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogModule;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.view.filter.ProjectFilters;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.InputValidator;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.util.Identifier;

public class CloneXObjectAction
extends FuegoObjectAction {
    private ObjectTypeDescription otd;

    public CloneXObjectAction(ObjectTypeDescription otd) {
        super(DesignerMsg.CLONE);
        this.requires(ObjectTypeDescription.class);
        this.otd = otd;
        this.setShowOnDisabled(false);
    }

    @Override
    public void run() {
        this.cloneXObject();
    }

    @Override
    protected void updateEnableStatus(Selection selectedObject) {
        ObjectTypeDescription objectType = (ObjectTypeDescription)selectedObject.as(ObjectTypeDescription.class);
        this.setEnabled(!objectType.isInnerType() && (objectType.isBpmObject() || objectType.isEnum()));
    }

    private Project getFuegoProject() {
        return FuegoProject.getFrom((TypeRef)this.otd);
    }

    private boolean cloneXObject() {
        String name;
        CatalogType currentModule = CatalogObjectImpl.get((TypeRef)this.otd.getParentRef().get());
        CatalogModule parent = new ProjectNavigatorBuilder((ProjectObject)this.getFuegoProject().getCatalogRoot(), DesignerMsg.BROWSE_MODULES).filter(ProjectFilters.BUSINESS_CATALOG_MODULES).initialSelection((ProjectObject)currentModule).selectSingle(CatalogModule.class);
        if (parent == null) {
            return false;
        }
        int counter = 1;
        while (parent.findInnerType(name = "BusinessObject" + counter++) != null) {
        }
        boolean passed = false;
        while (!passed) {
            BPMObjectNameInputValidator validator = new BPMObjectNameInputValidator(parent.getDelegate());
            name = MessageDialog.showInputModule((UiWindow)Ui.getRoot(), (Msg)DesignerMsg.NEW_NAME, (Msg)DesignerMsg.RENAME, (InputValidator)validator, (String)name);
            passed = true;
            if (name == null) {
                return false;
            }
            if (!Identifier.isValid(name)) {
                MessageDialog.showError((Msg)DesignerMsg.INVALID_IDENTIFIER);
                passed = false;
                continue;
            }
            if (parent.findInnerType(name) == null) continue;
            MessageDialog.showError((Msg)UIMsg.COMPONENT_NAME_ALREADY_EXISTS((String)name));
            passed = false;
        }
        XObjectTypeDescription newType = (XObjectTypeDescription)((XObjectTypeDescription)this.otd).copy(name);
        AddObjectTypeDescriptionAction add = new AddObjectTypeDescriptionAction(parent.getDelegate().asObject(), newType);
        add.run();
        OpenCatalogNodeAction oca = new OpenCatalogNodeAction();
        oca.runWithSelection(newType);
        return oca.isSuccess();
    }
}

