/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.command.Command;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.command.design.ChangeMeasurementTargetCommand;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.msg.UIMsg;
import org.jetbrains.annotations.NotNull;

public class ChangeMeasurementTargetAction
extends DesignerAction {
    private SequenceFlow sequenceFlow;

    public ChangeMeasurementTargetAction(@NotNull SequenceFlow sequenceFlow) {
        super(UIMsg.TO_MSG((String)(sequenceFlow.getSource().getDefaultLabel() + " -> " + sequenceFlow.getTarget().getDefaultLabel())));
        this.requires(Measurement.class);
        this.setSmallIcon(this.resolveSmallIcon(sequenceFlow));
        this.sequenceFlow = sequenceFlow;
    }

    @Override
    public void run() {
        this.getRunner().run((Command)new ChangeMeasurementTargetCommand(this.getMeasurement(), this.sequenceFlow));
    }

    private Measurement getMeasurement() {
        return (Measurement)this.getSelection().as(Measurement.class);
    }

    private Image resolveSmallIcon(@NotNull SequenceFlow sequenceFlow) {
        return Image.create((Msg)(sequenceFlow.isConditionalFlow() ? DesignerMsg.TREE_TRANSITION_CONDITIONAL : DesignerMsg.TREE_TRANSITION));
    }
}

