/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.collections.Function;
import oracle.bpm.command.Command;
import oracle.bpm.designer.ActionRunner;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesDialog;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesPreferences;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.draw.figure.FlowFigureUtils;
import oracle.bpm.draw.themes.DefaultTheme;
import oracle.bpm.draw.themes.ImageType;
import oracle.bpm.project.command.design.ChangeTriggerTypeCommand;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.FlowNode;
import org.jetbrains.annotations.NotNull;

public final class ChangeEventTriggerTypeAction
extends DesignerAction {
    private final EventTriggerType type;

    public ChangeEventTriggerTypeAction(@NotNull BpmnType eventType, @NotNull EventTriggerType type) {
        super(type.getLabel());
        DefaultTheme theme = DesignerPreferences.getPreferences().getTheme();
        this.setSmallIcon(theme.getImageFor(FlowFigureUtils.fromEvent((BpmnType)eventType, (EventTriggerType)type), ImageType.ICON));
        this.requires(Event.class);
        this.type = type;
    }

    @Override
    public void run() {
        FlowNodePropertiesPreferences preferences = FlowNodePropertiesPreferences.create();
        preferences.addAfterCopyFunction(new MutateEventFunction(this.type));
        preferences.setSelectedSheet(FlowNodePropertiesPreferences.SHOW_IMPLEMENTATION);
        Event event = this.getEvent();
        FlowNodePropertiesDialog.editProperties((FlowNode)event, preferences);
    }

    private Event getEvent() {
        return (Event)this.getSelection().as(Event.class);
    }

    private static final class MutateEventFunction
    implements Function<FlowNode, FlowNode> {
        private final EventTriggerType type;

        public MutateEventFunction(@NotNull EventTriggerType type) {
            this.type = type;
        }

        @Override
        public FlowNode eval(@NotNull FlowNode value) {
            Event event = (Event)value.asAnyNode(Event.class);
            if (event != null) {
                ActionRunner.getInstance().run((Command)new ChangeTriggerTypeCommand(event, this.type));
            }
            return event;
        }
    }
}

