/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.configuration.IntrospectionWizard;
import oracle.bpm.configuration.IntrospectorWizardMetadataUtils;
import oracle.bpm.configuration.NoIntrospectorWizardException;
import oracle.bpm.connector.ConnectorTransaction;
import oracle.bpm.designer.action.ImportObjectAction;
import oracle.bpm.designer.action.ModuleAction;
import oracle.bpm.designer.catalog.introspection.ComponentWizard;
import oracle.bpm.extension.Extension;
import oracle.bpm.extensionpoint.metadata.IntrospectorMetadata;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogModule;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.ComponentRenderer;
import oracle.bpm.type.Introspector;
import oracle.bpm.ui.FuegoActionContainer;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.wizards.model.Wizard;
import oracle.bpm.ui.wizards.model.WizardSupport;

public class CatalogComponentsAction
extends ModuleAction {
    private CatalogObject catalogObject;
    private String fileToIntrospect_d;
    private Extension<IntrospectorMetadata> introspectorExtension;

    public CatalogComponentsAction(Extension<IntrospectorMetadata> introspectorExtension) {
        super(CatalogComponentsAction.getMessage(introspectorExtension));
        this.introspectorExtension = introspectorExtension;
        this.setExcludeDefault(true);
        this.setExcludeRoot(true);
        this.setShowOnDisabled(false);
    }

    public CatalogComponentsAction(CatalogObject catalogObject, Extension<IntrospectorMetadata> introspectorExtension) {
        this(introspectorExtension);
        this.catalogObject = catalogObject;
    }

    public CatalogComponentsAction(CatalogObject catalogObject, Extension<IntrospectorMetadata> introspectorExtension, String fileToIntrospect) {
        this(catalogObject, introspectorExtension);
        this.fileToIntrospect_d = fileToIntrospect;
    }

    public static void addAllTo(FuegoActionContainer fuegoActionContainer, CatalogObject node) {
        List<Extension<IntrospectorMetadata>> list = Introspector.Extension.getAll();
        TreeMap<String, ImportObjectAction> map = new TreeMap<String, ImportObjectAction>();
        ModuleAction action = ImportObjectAction.getImportEnumerationAction(node);
        map.put(action.getMsg().getString(), (ImportObjectAction)action);
        action = ImportObjectAction.getImportFuegoObjectAction(node);
        map.put(action.getMsg().getString(), (ImportObjectAction)action);
        for (Extension<IntrospectorMetadata> extension : list) {
            action = new CatalogComponentsAction(node, extension);
            map.put(action.getMsg().getString(), (ImportObjectAction)action);
        }
        for (BaseAction baseAction : map.values()) {
            fuegoActionContainer.addFuegoAction(baseAction);
        }
    }

    public static void setUpEnvironment() {
        if (ConnectorTransaction.isStarted()) {
            try {
                ConnectorTransaction.current().rollback();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public boolean catalog() {
        CatalogModule container = this.catalogObject == null ? ModuleAction.selectModule(this.getProject()) : this.catalogObject.asModule();
        try {
            Introspector introspector = this.createInstrospector();
            Map<String, Object> properties = this.createIntrospectionProperties(container.getObjectType(), introspector);
            CatalogComponentsAction.setUpEnvironment();
            return this.createAndRunWizard(introspector, properties);
        }
        catch (NoIntrospectorWizardException noWizardException) {
            MessageDialog.showError((Msg)UIMsg.TO_MSG((String)("No wizard for " + this.introspectorExtension.getMetadata().type())), (Throwable)noWizardException);
            return false;
        }
        catch (Exception e1) {
            MessageDialog.showError((Msg)UIMsg.TO_MSG((String)("Error while making the introspector wizard " + this.introspectorExtension.getMetadata().type())), (Throwable)e1);
            return false;
        }
    }

    @Override
    public boolean doIt() {
        return this.catalog();
    }

    public void unDoIt() {
    }

    private static Msg getMessage(Extension<IntrospectorMetadata> introspectorExtension) {
        ComponentRenderer renderer = ComponentRenderer.Extension.find(introspectorExtension);
        return renderer != null ? renderer.getMsg() : CoreMsg.ERROR_MSG(introspectorExtension.getMetadata().type());
    }

    private Map<String, Object> createIntrospectionProperties(ObjectTypeDescription container, Introspector introspector) {
        Map<String, Object> properties = introspector.defaultProperties();
        assert (properties != null) : "properties are null. Check that the introspector default properties are properly built.";
        properties.put("parent_type_desc", container);
        if (this.fileToIntrospect_d != null) {
            properties.put("File_To_Introspect", this.fileToIntrospect_d);
        }
        return properties;
    }

    private boolean createAndRunWizard(Introspector introspector, Map<String, Object> properties) {
        IntrospectionWizard introspectorWizard = IntrospectorWizardMetadataUtils.createWizardFor((Introspector)introspector);
        ComponentWizard componentWizard = new ComponentWizard(this.getProject(), Ui.getRoot(), introspector);
        componentWizard.addSourceIntrospectorWizard((Wizard)introspectorWizard);
        componentWizard.build();
        componentWizard.setProperties(properties);
        WizardSupport support = componentWizard.getSupport();
        support.run();
        support.dispose();
        return true;
    }

    private Introspector createInstrospector() throws InstantiationException {
        return this.introspectorExtension.instantiateAs(Introspector.class);
    }

    private Project getProject() {
        return this.catalogObject.getProject();
    }
}

