/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import oracle.bpm.designer.action.ActionSet;
import oracle.bpm.designer.action.DelegateAction;
import oracle.bpm.ui.action.BaseAction;

public abstract class BaseActionSet
implements ActionSet {
    private ActionsMap actionsMap;
    public static final String cutActionId = "cut-action";
    public static final String copyActionId = "copy-action";
    public static final String pasteActionId = "paste-action";
    public static final String previousMethodActionId = "component-select-previous-method";
    public static final String nextMethodActionId = "component-select-next-method";
    public static final String methodsListActionId = "component-show-methods-list";

    public static void disableAction(Action action) {
        if (action instanceof DelegateAction) {
            DelegateAction delegateAction = (DelegateAction)((Object)action);
            delegateAction.setDelegateAction(null);
        }
        action.setEnabled(false);
    }

    public static void enableAction(DelegateAction action, BaseAction innerAction) {
        action.setDelegateAction(innerAction);
        action.setEnabled(true);
    }

    public ActionsMap getSharedActions() {
        if (this.actionsMap == null) {
            this.actionsMap = new ActionsMap();
            this.registerSharedActions(this.actionsMap);
        }
        return this.actionsMap;
    }

    protected void registerSharedActions(ActionsMap actionsMap) {
        actionsMap.clear();
    }

    public static class ActionsMap {
        private Map<String, BaseAction> actionsMap = new HashMap<String, BaseAction>();

        public void clear() {
            this.actionsMap.clear();
        }

        public void dump() {
            System.out.println("ActionsMap.dump {");
            for (Map.Entry<String, BaseAction> entry : this.actionsMap.entrySet()) {
                System.out.println("[" + entry.getKey() + ", " + entry.getValue().getClass() + "]");
            }
            System.out.println("}");
        }

        public BaseAction get(String name) {
            return this.actionsMap.get(name);
        }

        public void put(BaseAction action) {
            this.actionsMap.put((String)action.getValue("Name"), action);
        }

        public void put(String name, BaseAction action) {
            this.actionsMap.put(name, action);
        }
    }
}

