/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.bpmobject.design.BpmObjectTypeDescriptionHelper;
import oracle.bpm.bpmobject.design.ConstructionException;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.InputValidationException;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.ui.InputValidator;
import org.jetbrains.annotations.NotNull;

public class BPMObjectAttributeInputValidator
implements InputValidator {
    private CatalogObject object;

    public BPMObjectAttributeInputValidator(CatalogObject catalogObject) {
        this.object = catalogObject;
    }

    @Override
    public void validate(String newAttributeName) throws InputValidationException {
        if (newAttributeName == null) {
            return;
        }
        InputValidationException.assertNotEmpty(newAttributeName, DesignerMsg.OBJECT_NAME_CANNOT_BE_EMPTY);
        BPMObjectAttributeInputValidator.validateAttributeUniqueness(newAttributeName, this.object);
        try {
            BpmObjectTypeDescriptionHelper.validateAttributeName((String)newAttributeName);
        }
        catch (ConstructionException e) {
            throw new InputValidationException(DesignerMsg.INVALID_NAME);
        }
    }

    protected static void validateAttributeUniqueness(@NotNull String name, @NotNull CatalogObject object) throws InputValidationException {
        CatalogMember member = object.findMember(name);
        InputValidationException.assertFalse(member != null && member.isAttribute(), DesignerMsg.ATTRIBUTE_NAME_EXISTS);
    }
}

