/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.action.NewTransitionOperation;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.TransitionType;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;

public class AddTransitionAction
extends DesignerAction {
    private Process content;
    private FlowNode from;
    private FlowNode to;
    private SequenceFlow transition;
    private TransitionType transitionType;

    public AddTransitionAction(Process content, FlowNode from, FlowNode to, TransitionType type) {
        this(content, from, to, type, null);
    }

    public AddTransitionAction(Process content, FlowNode from, FlowNode to, TransitionType type, Msg msg) {
        super(msg == null ? (type == null ? DesignerMsg.ADD_TRANSITION : type.getMsgForNew()) : msg);
        this.requires(FlowNode.class);
        this.requires(SequenceFlow.class);
        this.content = content;
        this.transitionType = type;
        this.transition = this.content.createSequenceFlow();
        this.setFrom(from);
        this.setTo(to);
    }

    public Process getContent() {
        return this.content;
    }

    @Override
    public void run() {
        try {
            this.runOperation(new NewTransitionOperation(this.from, this.to, this.transitionType));
        }
        catch (ProjectException e) {
            MessageDialog.showError((Throwable)e);
        }
    }

    private void setFrom(FlowNode from) {
        if (from == null) {
            return;
        }
        this.from = from;
        this.transition.setSource(this.from);
    }

    private void setTo(FlowNode to) {
        if (to == null) {
            return;
        }
        this.to = to;
        this.transition.setTarget(this.to);
    }
}

