/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.command.Command;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.LanePropertiesDialog;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.command.design.AddLaneCommand;
import oracle.bpm.project.model.features.CustomizedImageFeature;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.LaneUtils;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.ui.Ui;
import org.jetbrains.annotations.NotNull;

public class AddLaneAction
extends DesignerAction {
    protected Lane newLane;
    protected int offset = -1;
    protected Process process;

    protected AddLaneAction(@NotNull Process process, int offset) {
        super(DesignerMsg.NEW_ROLE);
        this.requires(Process.class);
        this.process = process;
        this.offset = AddLaneAction.fixOffset(process, offset);
    }

    public static LaneInfo newLaneName(Process process, boolean includeAutomatic) {
        LanePropertiesDialog dialog = new LanePropertiesDialog(Ui.getRoot(), process, includeAutomatic, null);
        dialog.setVisible(true);
        LaneInfo result = dialog.userAccepted() ? new LaneInfo(dialog.getLaneName(), dialog.getBackgroundColor().getRGB(), dialog.getCustomImageId()) : null;
        return result;
    }

    public void setNewLane(Lane newLane) {
        this.newLane = newLane;
    }

    @Override
    public void run() {
        LaneInfo laneInfo = this.askLaneInfo();
        if (laneInfo != null) {
            AddLaneCommand command = new AddLaneCommand(this.process, laneInfo.getRoleId(), laneInfo.getBackgroundColor(), this.offset, true);
            command.setCustomImage(laneInfo.customImage);
            this.getRunner().run((Command)command);
        }
    }

    protected LaneInfo askLaneInfo() {
        return this.establishNewRoleName();
    }

    private static int fixOffset(Process process, int offset) {
        if (offset < 0) {
            Lane last = LaneUtils.getLastLane((Process)process);
            offset = last.getOffset() + last.getSize() + 1;
        }
        return offset;
    }

    private LaneInfo establishNewRoleName() {
        LaneInfo result;
        if (this.newLane != null && this.newLane.getRole() != null) {
            result = new LaneInfo(this.newLane.getRole(), -1761607681, ((CustomizedImageFeature)this.newLane.getFeature(CustomizedImageFeature.class)).getValue());
        } else {
            this.newLane = null;
            result = AddLaneAction.newLaneName(this.process, true);
        }
        return result;
    }

    public static class LaneInfo {
        int backgroundColor;
        String roleId;
        private String customImage;

        private LaneInfo(String roleId, int backgroundColor, String customImage) {
            this.roleId = roleId;
            this.backgroundColor = backgroundColor;
            this.customImage = customImage;
        }

        public String getRoleId() {
            return this.roleId;
        }

        public int getBackgroundColor() {
            return this.backgroundColor;
        }

        public String getCustomImage() {
            return this.customImage;
        }
    }
}

