/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.command.Command;
import oracle.bpm.designer.ActionRunner;
import oracle.bpm.designer.action.AddLaneAction;
import oracle.bpm.designer.command.EnsureLaneCommand;
import oracle.bpm.designer.command.SmartAddActivityCommand;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesDialog;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.draw.figure.FlowFigureType;
import oracle.bpm.draw.figure.FlowFigureTypeProvider;
import oracle.bpm.draw.figure.FlowFigureUtils;
import oracle.bpm.draw.themes.DefaultTheme;
import oracle.bpm.draw.themes.ImageType;
import oracle.bpm.geom.Point;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.design.LayoutModelCommand;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.PaintCanvas;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.BaseAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddFlowNodesActionGroup
extends ActionGroup {
    @Nullable
    private final PaintCanvas canvas;
    @NotNull
    private final NodeContainer container;
    @Nullable
    private final Point location;
    @Nullable
    private final SequenceFlow target;

    public AddFlowNodesActionGroup(@NotNull NodeContainer container, @NotNull Msg msg, @NotNull SequenceFlow target) {
        this(container, msg, null, target, null);
    }

    public AddFlowNodesActionGroup(@NotNull NodeContainer container, @NotNull Msg msg, @NotNull Point location, @NotNull PaintCanvas canvas) {
        this(container, msg, location, null, canvas);
    }

    private AddFlowNodesActionGroup(@NotNull NodeContainer container, @NotNull Msg msg, @Nullable Point location, @Nullable SequenceFlow target, @Nullable PaintCanvas canvas) {
        super(msg);
        this.container = container;
        this.location = location;
        this.target = target;
        this.canvas = canvas;
        this.addActions();
    }

    private void addActions() {
        ActionGroup tasksGroup = new ActionGroup(DesignerMsg.TASKS);
        this.add((BaseAction)tasksGroup);
        ActionGroup subprocessGroup = new ActionGroup(CoreMsg.SUBPROCESS);
        this.add((BaseAction)subprocessGroup);
        for (FlowFigureType type : FlowFigureTypeProvider.getNonDefaultActivities()) {
            ActionGroup currentGroup = type.getType() == BpmnType.SUBPROCESS ? subprocessGroup : tasksGroup;
            currentGroup.add((BaseAction)new CreateFlowNodeAction(type));
        }
        ActionGroup eventsGroup = new ActionGroup(DesignerMsg.EVENTS);
        this.add((BaseAction)eventsGroup);
        for (FlowFigureType type : FlowFigureTypeProvider.getDefaultEvents()) {
            if (type == FlowFigureType.CATCH_INTERMEDIATE_EVENT || type == FlowFigureType.THROW_INTERMEDIATE_EVENT) {
                eventsGroup.add((BaseAction)new CreateFlowNodeAction(type, type.getType().getShortLabel()));
                continue;
            }
            eventsGroup.add((BaseAction)new CreateFlowNodeAction(type));
        }
        ActionGroup gatewaysGroup = new ActionGroup(DesignerMsg.GATEWAYS);
        this.add((BaseAction)gatewaysGroup);
        for (FlowFigureType type : FlowFigureTypeProvider.getNonDefaultGateways()) {
            gatewaysGroup.add((BaseAction)new CreateFlowNodeAction(type));
        }
        for (FlowFigureType type : FlowFigureTypeProvider.getUserTasksActivities()) {
            tasksGroup.add((BaseAction)new CreateFlowNodeAction(type));
        }
        for (FlowFigureType type : FlowFigureTypeProvider.getNotificationActivities()) {
            tasksGroup.add((BaseAction)new CreateFlowNodeAction(type));
        }
    }

    private class CreateFlowNodeAction
    extends BaseAction {
        private final FlowFigureType type;

        private CreateFlowNodeAction(FlowFigureType type) {
            this(type, FlowFigureUtils.getNameForType((FlowFigureType)type));
        }

        private CreateFlowNodeAction(@NotNull FlowFigureType type, Msg msg) {
            super(msg);
            this.requires(FlowElement.class);
            this.type = type;
            this.setSmallIcon(DefaultTheme.getDefault().getImageFor(type, ImageType.ICON));
        }

        public void run() {
            FlowNode flowNode = FlowFigureUtils.createNodeFromFigureType((FlowFigureType)this.type, (NodeContainer)AddFlowNodesActionGroup.this.container);
            boolean cancelledByProperties = false;
            if (DesignerPreferences.getPreferences().showPropertiesAutomaticallyWhenAddingActivity() && !ModelUtils.isSubprocess((FlowNode)flowNode)) {
                boolean bl = cancelledByProperties = !FlowNodePropertiesDialog.editProperties(flowNode);
            }
            if (!cancelledByProperties) {
                Point destination = AddFlowNodesActionGroup.this.location;
                if (destination == null) {
                    destination = AddFlowNodesActionGroup.this.target != null ? this.getLocationFromSequenceFlow(AddFlowNodesActionGroup.this.target) : Point.ORIGIN;
                }
                boolean needs = EnsureLaneCommand.needsNewLane(destination, flowNode);
                AddLaneAction.LaneInfo lane = null;
                if (needs) {
                    lane = AddLaneAction.newLaneName(AddFlowNodesActionGroup.this.container.getProcess(), false);
                }
                if (!needs || lane != null) {
                    MultipleCommand result = new MultipleCommand(new ProjectObject[]{AddFlowNodesActionGroup.this.container.getProcess()});
                    result.addCommand((Command)((Object)new SmartAddActivityCommand(flowNode, lane, destination, AddFlowNodesActionGroup.this.target)));
                    if (DesignerPreferences.getPreferences().isAutoLayout()) {
                        result.addCommand((Command)new LayoutModelCommand(AddFlowNodesActionGroup.this.container.getProcess(), DesignerPreferences.getPreferences().isOptimizeLanesOnAutoLayout()));
                    }
                    ActionRunner.getInstance().run((Command)result);
                    if (AddFlowNodesActionGroup.this.canvas != null) {
                        AddFlowNodesActionGroup.this.canvas.repaint();
                    }
                }
            }
        }

        private Point getLocationFromSequenceFlow(@NotNull SequenceFlow flow) {
            FlowNode source = flow.getSource();
            FlowNode target = flow.getTarget();
            return source.getLocation().add(target.getLocation()).div(2);
        }
    }
}

