/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.action.ModifyAttributeAccessorAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.SourceCode;
import org.jetbrains.annotations.NotNull;

public class AddAttributeAccessorAction
extends ModifyAttributeAccessorAction {
    private SourceCode code;
    private AttributeTypeDescription member;

    public AddAttributeAccessorAction(@NotNull AttributeTypeDescription attribute, int accessorType) {
        super(DesignerMsg.READ_ACCESS_CODE, accessorType);
        this.member = attribute;
        if (this.getAccessorType() == 8) {
            this.setMsg(DesignerMsg.OVERRIDE_READ_CODE);
        } else {
            this.setMsg(DesignerMsg.OVERRIDE_WRITE_CODE);
        }
    }

    protected static SourceCode createCode(int accessorType, AttributeTypeDescription member) {
        String source = "";
        if (accessorType == 8) {
            source = "return " + AddAttributeAccessorAction.getGetterValue(member);
        } else if (accessorType == 7 && !member.isVirtual()) {
            String argumentName = "value";
            if (member.getName().equals(argumentName)) {
                argumentName = "arg." + argumentName;
            }
            source = member.getName() + " = " + argumentName;
        }
        SourceCode code = new SourceCode();
        code.setText(source.toCharArray());
        return code;
    }

    @Override
    protected SourceCode getCode() {
        if (this.code == null) {
            this.code = AddAttributeAccessorAction.createCode(this.getAccessorType(), this.member);
        }
        return this.code;
    }

    @Override
    protected AttributeTypeDescription getAttribute() {
        return this.member;
    }

    @Override
    protected void updateAttribute() {
        if (this.getAccessorType() == 8) {
            this.getAttribute().setHasGetter(true);
        } else {
            this.getAttribute().setHasSetter(true);
        }
    }

    private static String getGetterValue(AttributeTypeDescription member) {
        String defValue = "null";
        if (member.isVirtual()) {
            TypeDescription resultType = member.getResultType();
            if (resultType != null) {
                int kind = resultType.getKind();
                if (resultType.isNumber()) {
                    defValue = "0";
                } else if (kind == 5) {
                    defValue = "\"\"";
                } else if (kind == 6) {
                    defValue = "'now'";
                } else if (kind == 7) {
                    defValue = "'0s'";
                } else if (kind == 1) {
                    defValue = "false";
                }
            }
        } else {
            defValue = member.getName();
        }
        return defValue;
    }
}

