/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.ui.action.BaseAction;

public class ActionBindingMap {
    private Map<String, List<Binding>> bindingMap;
    private static ActionBindingMap instance;
    public static final String EXTENSION = "-binding";

    private ActionBindingMap() {
    }

    public static ActionBindingMap getInstance() {
        if (instance == null) {
            instance = new ActionBindingMap();
        }
        return instance;
    }

    public Binding get(String key, Class scope) {
        Map<String, List<Binding>> bindingMap = this.getBindingMap();
        if (!bindingMap.containsKey(key)) {
            return null;
        }
        for (Binding binding : bindingMap.get(key)) {
            if (!scope.equals(binding.getScope())) continue;
            return binding;
        }
        return null;
    }

    public void register(Binding binding) {
        List<Object> bindingList;
        Map<String, List<Binding>> bindingMap = this.getBindingMap();
        if (!bindingMap.containsKey(binding.getKey())) {
            bindingList = new ArrayList();
            bindingMap.put(binding.getKey(), bindingList);
        } else {
            bindingList = bindingMap.get(binding.getKey());
        }
        bindingList.add(binding);
    }

    private Map<String, List<Binding>> getBindingMap() {
        if (this.bindingMap == null) {
            this.bindingMap = new HashMap<String, List<Binding>>();
        }
        return this.bindingMap;
    }

    public static class Binding {
        private BaseAction action;
        private String key;
        private Class scope;

        public Binding(String key, Class scope, BaseAction action) {
            this.key = key;
            this.scope = scope;
            this.action = action;
        }

        public BaseAction getAction() {
            return this.action;
        }

        public String getKey() {
            return this.key;
        }

        public Class getScope() {
            return this.scope;
        }
    }
}

