/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import java.io.IOException;
import java.net.URL;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.RepositoryAdapter;
import oracle.bpm.project.model.RepositoryService;
import oracle.bpm.project.model.events.RepositoryListener;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CustomFuegoAction;
import oracle.bpm.ui.FuegoWorker;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.browser.BrowserLauncherDialog;
import oracle.bpm.ui.selection.Selection;

public abstract class AbstractWebAppLauncherAction
extends CustomFuegoAction {
    private boolean launchBrowserOnStart;

    public AbstractWebAppLauncherAction(Msg msg) {
        super(msg);
        this.requires(Project.class);
        Listener listener = new Listener();
        RepositoryService.getInstance().getActiveRepository().addRepositoryListener((RepositoryListener)listener);
        AbstractStudioWorkbench.addEngineListener(listener);
    }

    public void run() {
        new FuegoWorker.Action(this.getMsg(), (FuegoWorker.Procedure)new LaunchWebAppProcedure()).run();
    }

    protected abstract String getWebAppUrl(Project var1);

    protected void updateEnableStatus(Selection selection) {
        this.setEnabled(this.isEnabledFor(selection));
    }

    protected boolean isEnabledFor(Selection selection) {
        ProjectObject object = (ProjectObject)selection.as(ProjectObject.class);
        return object != null && object.getProject().isOpen();
    }

    private void launchBrowser(Project project) {
        try {
            if (project != null) {
                BrowserLauncherDialog.openURL((UiWindow)Ui.getRoot(), (URL)new URL(this.getWebAppUrl(project)));
            }
            this.launchBrowserOnStart = false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class LaunchWebAppProcedure
    implements FuegoWorker.Procedure {
        LaunchWebAppProcedure() {
        }

        public void run() {
            if (AbstractWebAppLauncherAction.this.getSelection() == null) {
                return;
            }
            Project project = (Project)AbstractWebAppLauncherAction.this.getSelection().as(Project.class);
            String name = project.getName();
        }
    }

    class Listener
    extends RepositoryAdapter
    implements Runnable,
    AbstractStudioWorkbench.EngineListener {
        private Project project;

        Listener() {
        }

        @Override
        public void run() {
            AbstractWebAppLauncherAction.this.launchBrowser(this.project);
        }

        @Override
        public void engineStarted(Project project) {
            if (AbstractWebAppLauncherAction.this.launchBrowserOnStart) {
                this.project = project;
                UiUtilities.invokeLater((Runnable)this);
            }
        }

        @Override
        public void engineStopped(Project project) {
        }

        public void projectOpened(Project project) {
            AbstractWebAppLauncherAction.this.setSelection(AbstractStudioWorkbench.getInstance().getSelectionProvider().getSelection());
        }

        public void projectClosed(Project project) {
            AbstractWebAppLauncherAction.this.setSelection(AbstractStudioWorkbench.getInstance().getSelectionProvider().getSelection());
        }
    }
}

