/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.UiComponent;

public class TypesListRenderer
extends DefaultListCellRenderer {
    Image componentIcon_d;
    private static Image componentIcon;
    static final long serialVersionUID = 7227084802763120901L;
    static final long serialCheck = 5294656617911062955L;

    public static Image getComponentIcon() {
        if (componentIcon == null) {
            componentIcon = Image.create((Msg)DesignerMsg.COMPONENT);
        }
        return componentIcon;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
        UiComponent c = UiComponent.get((Object)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus));
        if (!(value instanceof TypeRef)) {
            return c.asSwing();
        }
        TypesListRenderer.getLabel((Label)c, (TypeRef)value);
        return this;
    }

    private static Label getLabel(Label label, TypeRef typeRef) {
        label.setText(TypesListRenderer.getVisibleName(typeRef.getText()));
        label.setIcon(TypesListRenderer.getComponentIcon());
        return label;
    }

    private static String getVisibleName(String rawname) {
        String visibleName = "";
        if (rawname.indexOf(".") != -1) {
            String firstName = rawname.substring(rawname.lastIndexOf(".") + 1);
            String packageName = rawname.substring(0, rawname.lastIndexOf("."));
            visibleName = "<html><body><b>" + firstName + "</b> <font color=\"#999999\">(" + packageName + ")</font></body></html>";
        } else {
            visibleName = "<html><body><b>" + rawname + "</b></body></html>";
        }
        return visibleName;
    }
}

