/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.ArrayList;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.EventTypeRibbonItem;
import oracle.bpm.designer.FlowFigureTypeRibbonItem;
import oracle.bpm.designer.ProcessDomain;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.draw.figure.FlowFigureType;
import oracle.bpm.draw.figure.FlowFigureTypeProvider;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.RibbonItem;
import oracle.bpm.ui.RibbonSectionMultiple;
import oracle.bpm.ui.UiContainer;

public class ThrowEventRibbonSection
extends RibbonSectionMultiple {
    private RibbonItem defaultItem;
    private ProcessDomain domain;

    public ThrowEventRibbonSection(UiContainer parent, ProcessDomain domain) {
        super(parent);
        this.domain = domain;
        super.loadSection();
    }

    public Sequence<RibbonItem> loadItems() {
        ArrayList<EventTypeRibbonItem> list = new ArrayList<EventTypeRibbonItem>();
        Sequence<FlowFigureType> sequence = CollectionUtils.concat(FlowFigureTypeProvider.getNonDefaultThrowEvents(), FlowFigureTypeProvider.getEndEvents());
        FlowFigureType defaultValue = this.getDefaultType();
        for (FlowFigureType flowFigureType : sequence) {
            EventTypeRibbonItem item = this.domain == null ? new EventTypeRibbonItem(null, flowFigureType) : new EventTypeRibbonItem(this.domain.getStateManager(), flowFigureType);
            if (defaultValue.equals((Object)item.getType())) {
                this.defaultItem = item;
            }
            list.add(item);
        }
        return CollectionUtils.asSequence(list);
    }

    public Msg getTitle() {
        return DesignerMsg.TEXT_RIBBON_THROW_EVENTS_LABEL;
    }

    public RibbonItem getDefault() {
        if (this.defaultItem == null) {
            throw new ExceptionInInitializerError();
        }
        return this.defaultItem;
    }

    public void setDefault(RibbonItem defaultItem) {
        this.defaultItem = defaultItem;
        DesignerPreferences designerPreferences = DesignerPreferences.getPreferences();
        designerPreferences.setLastThrowRibbonSection(((FlowFigureTypeRibbonItem)defaultItem).getType());
        designerPreferences.store();
    }

    private FlowFigureType getDefaultType() {
        DesignerPreferences designerPreferences = DesignerPreferences.getPreferences();
        FlowFigureType lastPreference = designerPreferences.getLastThrowRibbonSection();
        if (lastPreference != null) {
            return lastPreference;
        }
        return FlowFigureType.END_EVENT;
    }
}

