/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.List;
import oracle.bpm.designer.AppInfo;
import oracle.bpm.designer.DesignerException;
import oracle.bpm.designer.DesignerMode;
import oracle.bpm.designer.ProjectNavigatorTree;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.draw.ActivityTitle;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.TitlePanel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.browser.BrowserLauncherPanel;
import oracle.bpm.ui.browser.launcher.BrowserLauncher;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.BoxLayout;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.pref.Category;
import oracle.bpm.ui.pref.PreferencesDialog;
import oracle.bpm.ui.tree.TreeNode;
import oracle.bpm.util.ArrayUtils;
import oracle.bpm.util.CommonPreferences;

public class StudioPreferencesDialog
extends PreferencesDialog
implements ItemListener {
    private ComboBox actDClickComboBox;
    private ComboBox<ActivityTitle> actTitleLabel;
    private CheckBox autoLayout;
    private BrowserLauncherPanel browserLauncherPanel;
    private CheckBox keepAddingCheckBox;
    private CheckBox optimizeLanesOnAutoLayout;
    private CheckBox showActPropsCheckBox;
    private CheckBox showConfirmationWhenReplacingTask;
    private CheckBox showHiddenComponents;
    private CheckBox showTooltipsOnActivities;

    public StudioPreferencesDialog(UiWindow parent) {
        super(parent, UIMsg.PREFERENCES, true);
    }

    public void cancel() {
        this.getParent().repaint();
        super.cancel();
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.showActPropsCheckBox && this.showActPropsCheckBox.isSelected()) {
            this.keepAddingCheckBox.setSelected(false);
        }
        if (e.getSource() == this.keepAddingCheckBox && this.keepAddingCheckBox.isSelected()) {
            this.showActPropsCheckBox.setSelected(false);
        }
    }

    public void ok() {
        boolean showHiddenChanged;
        try {
            this.checkValues();
        }
        catch (DesignerException dexc) {
            MessageDialog.showError((Throwable)((Object)dexc));
            return;
        }
        DesignerPreferences preferences = DesignerPreferences.getPreferences();
        CommonPreferences commonPref = CommonPreferences.getInstance();
        boolean bl = showHiddenChanged = this.showHiddenComponents != null && this.showHiddenComponents.isSelected() != preferences.isShowHiddenComponents();
        if (showHiddenChanged) {
            preferences.setShowHiddenComponents(this.showHiddenComponents.isSelected());
        }
        if (this.browserLauncherPanel != null) {
            CommonPreferences.getInstance().setDefaultBrowser(this.browserLauncherPanel.getCommand());
        }
        preferences.setAddingActivityMode(this.keepAddingCheckBox.isSelected());
        preferences.setActivityTitleType((ActivityTitle)this.actTitleLabel.getSelectedItem());
        if (this.showConfirmationWhenReplacingTask != null) {
            preferences.setShowConfirmWhenReplacingActivityImplementation(this.showConfirmationWhenReplacingTask.isSelected());
        }
        preferences.setOptimizeLanesOnAutoLayout(this.optimizeLanesOnAutoLayout.isSelected());
        if (this.actDClickComboBox.getSelectedIndex() == 0) {
            preferences.setActivityDoubleClick(0);
        } else {
            preferences.setActivityDoubleClick(1);
        }
        preferences.showPropertiesAutomaticallyWhenAddingActivity(this.showActPropsCheckBox.isSelected());
        preferences.setShowTooltipsOnActivities(this.showTooltipsOnActivities.isSelected());
        preferences.setAutoLayout(this.autoLayout.isSelected());
        this.getParent().repaint();
        preferences.store();
        if (showHiddenChanged) {
            ProjectNavigatorTree.refreshRootTreeFilter();
        }
        preferences.store();
        commonPref.store();
        this.close();
    }

    public void addCategory(Category childCategory, TitlePanel editorsParent) {
        super.addCategory(childCategory, editorsParent);
    }

    protected void checkValues() throws DesignerException {
    }

    protected void loadDefaultCategories() {
        TitlePanel generalTitlePanel = new TitlePanel((UiContainer)this.getCardPanel());
        Category generalCategory = new Category(DesignerMsg.GENERAL.getString(), (UiComponent)this.createGeneralPanel((UiContainer)generalTitlePanel));
        generalTitlePanel.setTitle(this.fixTitle(generalCategory.getId()));
        this.addCategory(generalCategory, generalTitlePanel);
        TitlePanel activityTitlePanel = new TitlePanel((UiContainer)this.getCardPanel());
        Category activityCategory = new Category(ProjectMsg.ACTIVITY.getString(), (UiComponent)this.createActivityPanel((UiContainer)activityTitlePanel));
        activityTitlePanel.setTitle(this.fixTitle(activityCategory.getId()));
        this.addCategory(activityCategory, activityTitlePanel);
        TreeNode firstChild = this.getCategoryTree().getRoot().getFirstChild();
        firstChild.select();
        this.checkAutoLayout();
    }

    private String fixTitle(String s) {
        return s.replace(".", ": ");
    }

    private Panel createActivityPanel(UiContainer parent) {
        String dClickPanelID;
        DesignerPreferences preferences = DesignerPreferences.getPreferences();
        Panel centerPanel = new Panel(parent);
        RelativeLayout layout = new RelativeLayout();
        centerPanel.setLayout((Layout)layout);
        Panel clickPanel = new Panel((UiContainer)centerPanel, DesignerMsg.EMPTY_MSG(""));
        clickPanel.setLayout((Layout)new FlowLayout(3));
        Label doubleClickLabel = Label.create((UiContainer)clickPanel, (Msg)DesignerMsg.ON_DOUBLE_CLICK_SHOW);
        List<Msg> list1 = ArrayUtils.asList(new Msg[]{DesignerMsg.PROPERTIES, DesignerMsg.IMPLEMENTATION});
        this.actDClickComboBox = UiFactory.createComboBox((UiContainer)clickPanel, list1);
        this.actDClickComboBox.addItemListener((ItemListener)this);
        if (preferences.getActivityDoubleClick() == 0) {
            this.actDClickComboBox.setSelectedIndex(0);
        } else {
            this.actDClickComboBox.setSelectedIndex(1);
        }
        clickPanel.add((UiComponent)doubleClickLabel);
        clickPanel.add((UiComponent)this.actDClickComboBox);
        clickPanel.makeRecyclable();
        Panel titlePanel = new Panel((UiContainer)centerPanel, DesignerMsg.EMPTY_MSG(""));
        titlePanel.setLayout((Layout)new FlowLayout(3));
        Label titleLabel = Label.create((UiContainer)titlePanel, (Msg)DesignerMsg.SHOW_AS_TITLE);
        this.actTitleLabel = UiFactory.createComboBox((UiContainer)titlePanel, (Object[])ActivityTitle.values());
        this.actTitleLabel.setSelectedItem((Object)preferences.getActivityTitleType());
        titlePanel.add((UiComponent)titleLabel);
        titlePanel.add(this.actTitleLabel);
        Panel generalPanel = new Panel((UiContainer)centerPanel, DesignerMsg.GENERAL);
        generalPanel.setLayout((Layout)new BoxLayout((UiContainer)generalPanel, 1));
        this.showActPropsCheckBox = CheckBox.create((UiContainer)generalPanel, (Msg)DesignerMsg.SHOW_PROPS_WHEN_ADDING);
        this.showActPropsCheckBox.setSelected(preferences.showPropertiesAutomaticallyWhenAddingActivity());
        this.showActPropsCheckBox.addItemListener((ItemListener)this);
        this.keepAddingCheckBox = CheckBox.create((UiContainer)generalPanel, (Msg)DesignerMsg.AUTO_ADD_ACT);
        this.keepAddingCheckBox.setSelected(preferences.getAddingActivityMode());
        this.keepAddingCheckBox.addItemListener((ItemListener)this);
        this.showTooltipsOnActivities = CheckBox.create((UiContainer)generalPanel, (Msg)DesignerMsg.SHOW_TOOLTIPS_ON_ACTIVITIES);
        this.showTooltipsOnActivities.setSelected(preferences.getShowTooltipsOnActivities());
        this.autoLayout = CheckBox.create((UiContainer)generalPanel, (Msg)DesignerMsg.AUTOLAYOUT_WHEN_ADDING);
        this.autoLayout.setSelected(preferences.isAutoLayout());
        this.autoLayout.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                StudioPreferencesDialog.this.checkAutoLayout();
            }
        });
        generalPanel.add((UiComponent)this.showActPropsCheckBox);
        generalPanel.add((UiComponent)this.keepAddingCheckBox);
        generalPanel.add((UiComponent)this.showTooltipsOnActivities);
        generalPanel.add((UiComponent)this.autoLayout);
        Panel messagesPanel = new Panel((UiContainer)centerPanel, DesignerMsg.MESSAGES);
        messagesPanel.makeRecyclable();
        messagesPanel.setLayout((Layout)new BoxLayout((UiContainer)messagesPanel, 1));
        this.showConfirmationWhenReplacingTask = CheckBox.create((UiContainer)messagesPanel, (Msg)DesignerMsg.SHOW_CONFIRM_WHEN_REPLACING_TASK);
        this.showConfirmationWhenReplacingTask.setSelected(preferences.getShowConfirmWhenReplacingActivityImplementation());
        this.optimizeLanesOnAutoLayout = CheckBox.create((UiContainer)messagesPanel, (Msg)DesignerMsg.PRUNE_INTERACTIVE, (boolean)preferences.isOptimizeLanesOnAutoLayout());
        messagesPanel.add((UiComponent)this.showConfirmationWhenReplacingTask);
        messagesPanel.add((UiComponent)this.optimizeLanesOnAutoLayout);
        String generalPanelID = "generalPanel";
        String titleParent = dClickPanelID = "doubleClickPanel";
        if (!DesignerMode.isValid(2)) {
            titleParent = generalPanelID;
        }
        centerPanel.add((UiComponent)generalPanel, (Object)generalPanelID);
        String messagesPanelID = "messagesPanel";
        centerPanel.add((UiComponent)messagesPanel, (Object)messagesPanelID);
        centerPanel.add((UiComponent)clickPanel, (Object)dClickPanelID);
        centerPanel.add((UiComponent)messagesPanel, (Object)messagesPanelID);
        String titlePanelID = "titlePanel";
        centerPanel.add((UiComponent)titlePanel, (Object)titlePanelID);
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)generalPanelID, (AttributeType)AttributeType.TOP, (int)2);
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)generalPanelID, (AttributeType)AttributeType.LEFT, (int)2);
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)generalPanelID, (AttributeType)AttributeType.RIGHT, (int)-2);
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)layout, (String)messagesPanelID, (AttributeType)AttributeType.TOP, (String)generalPanelID, (AttributeType)AttributeType.BOTTOM, (int)5);
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)layout, (String)messagesPanelID, (AttributeType)AttributeType.LEFT, (String)generalPanelID);
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)layout, (String)messagesPanelID, (AttributeType)AttributeType.RIGHT, (String)generalPanelID);
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)layout, (String)dClickPanelID, (AttributeType)AttributeType.TOP, (String)messagesPanelID, (AttributeType)AttributeType.BOTTOM, (int)5);
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)layout, (String)dClickPanelID, (AttributeType)AttributeType.LEFT, (String)messagesPanelID);
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)layout, (String)dClickPanelID, (AttributeType)AttributeType.RIGHT, (String)messagesPanelID);
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)layout, (String)titlePanelID, (AttributeType)AttributeType.TOP, (String)titleParent, (AttributeType)AttributeType.BOTTOM, (int)5);
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)layout, (String)titlePanelID, (AttributeType)AttributeType.LEFT, (String)generalPanelID);
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)layout, (String)titlePanelID, (AttributeType)AttributeType.RIGHT, (String)generalPanelID);
        if (!DesignerMode.isValid(2)) {
            messagesPanel.setVisible(false);
            clickPanel.setVisible(false);
        }
        return centerPanel;
    }

    private void checkAutoLayout() {
        if (this.autoLayout.isSelected()) {
            this.optimizeLanesOnAutoLayout.setSelected(true);
            this.optimizeLanesOnAutoLayout.setEnabled(false);
        } else {
            this.optimizeLanesOnAutoLayout.setEnabled(true);
        }
    }

    private Panel createGeneralPanel(UiContainer parent) {
        RelativeLayout layout = new RelativeLayout();
        Panel centerPanel = new Panel(parent);
        centerPanel.setLayout((Layout)layout);
        DesignerPreferences preferences = DesignerPreferences.getPreferences();
        Panel studioPanel = new Panel((UiContainer)centerPanel, DesignerMsg.PROCESS_STUDIO(AppInfo.getCurrent().getApplicationNameMsg()));
        boolean showDefaultBrowser = BrowserLauncher.isBrowserConfigurable();
        Panel browserPanel = null;
        if (showDefaultBrowser) {
            browserPanel = new Panel((UiContainer)centerPanel, DesignerMsg.DEFAULT_BROWSER);
            browserPanel.setLayout((Layout)new BorderLayout());
            this.browserLauncherPanel = new BrowserLauncherPanel((UiContainer)browserPanel);
            browserPanel.add((UiComponent)this.browserLauncherPanel, (Object)"Center");
            String defaultBrowser = CommonPreferences.getInstance().getDefaultBrowser();
            if (defaultBrowser == null) {
                defaultBrowser = BrowserLauncher.getConfigurableBrowser();
            }
            this.browserLauncherPanel.setCommand(defaultBrowser);
        }
        BoxLayout studioPanelLayout = new BoxLayout((UiContainer)studioPanel, 1);
        studioPanel.setLayout((Layout)studioPanelLayout);
        if (DesignerMode.isValid(2)) {
            this.showHiddenComponents = CheckBox.create((UiContainer)studioPanel, (Msg)DesignerMsg.SHOW_HIDDEN);
            this.showHiddenComponents.setSelected(preferences.isShowHiddenComponents());
            studioPanel.add((UiComponent)this.showHiddenComponents);
        }
        String studioPanelID = "studioPanel";
        centerPanel.add((UiComponent)studioPanel, (Object)studioPanelID);
        String browserPanelID = "browserPanel";
        if (showDefaultBrowser) {
            centerPanel.add((UiComponent)browserPanel, (Object)browserPanelID);
        }
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)layout, (String)studioPanelID, (AttributeType)AttributeType.LEFT, (String)"_container");
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)layout, (String)studioPanelID, (AttributeType)AttributeType.TOP, (String)"_container", (AttributeType)AttributeType.TOP, (int)5);
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)studioPanelID, (AttributeType)AttributeType.RIGHT, (int)-2);
        String generalPanelID = "generalPanel";
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)layout, (String)generalPanelID, (AttributeType)AttributeType.LEFT, (String)studioPanelID);
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)layout, (String)generalPanelID, (AttributeType)AttributeType.TOP, (String)studioPanelID, (AttributeType)AttributeType.BOTTOM, (int)5);
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)generalPanelID, (AttributeType)AttributeType.RIGHT, (int)-2);
        if (showDefaultBrowser) {
            oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)layout, (String)browserPanelID, (AttributeType)AttributeType.LEFT, (String)generalPanelID);
            oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)layout, (String)browserPanelID, (AttributeType)AttributeType.TOP, (String)generalPanelID, (AttributeType)AttributeType.BOTTOM, (int)5);
            oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)browserPanelID, (AttributeType)AttributeType.RIGHT, (int)-2);
        }
        return centerPanel;
    }
}

