/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.awt.Graphics;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;
import oracle.bpm.designer.DesignerApplication;
import oracle.bpm.draw.Color;
import oracle.bpm.geom.Point;
import oracle.bpm.ui.Beep;
import oracle.bpm.ui.MenuBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.event.KeyEvent;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.peer.swing.AwtConverter;
import oracle.bpm.ui.peer.swing.event.SwingKeyListener;

public class StudioGlassPane
extends JComponent {
    Point point;
    static final long serialVersionUID = 4802854115575087174L;
    static final long serialCheck = -7910061107811016457L;

    public StudioGlassPane() {
        CBListener listener = new CBListener(this, DesignerApplication.getInstance().getContentPane());
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.addKeyListener((KeyListener)SwingKeyListener.get((oracle.bpm.ui.event.KeyListener)listener));
    }

    public void setPoint(Point p) {
        this.point = p;
    }

    @Override
    public void paint(Graphics g) {
        if (this.point != null) {
            g.setColor(AwtConverter.toAwt((Color)Color.RED));
            g.fillOval(this.point.getX() - 10, this.point.getY() - 10, 20, 20);
        }
    }

    public static class CBListener
    extends MouseInputAdapter
    implements oracle.bpm.ui.event.KeyListener {
        UiContainer contentPane;
        StudioGlassPane glassPane;
        boolean inDrag = false;
        MenuBar menuBar;

        public CBListener(StudioGlassPane glassPane, UiContainer contentPane) {
            this.glassPane = glassPane;
            this.contentPane = contentPane;
        }

        public void keyPressed(KeyEvent e) {
            this.manageKeyEvent(e);
        }

        public void keyReleased(KeyEvent e) {
            this.manageKeyEvent(e);
        }

        public void keyTyped(KeyEvent e) {
            this.manageKeyEvent(e);
        }

        public void mouseClicked(MouseEvent e) {
            this.redispatchMouseEvent(e, false);
        }

        public void mouseDragged(MouseEvent e) {
            this.redispatchMouseEvent(e, false);
        }

        public void mouseEntered(MouseEvent e) {
            this.redispatchMouseEvent(e, false);
        }

        public void mouseExited(MouseEvent e) {
            this.redispatchMouseEvent(e, false);
        }

        public void mouseMoved(MouseEvent e) {
            this.redispatchMouseEvent(e, false);
        }

        public void mousePressed(MouseEvent e) {
            this.redispatchMouseEvent(e, false);
        }

        public void mouseReleased(MouseEvent e) {
            this.redispatchMouseEvent(e, true);
            this.inDrag = false;
        }

        private void manageKeyEvent(KeyEvent e) {
            System.out.println("Key typed");
            e.consume();
        }

        private void redispatchMouseEvent(MouseEvent e, boolean repaint) {
            Point glassPanePoint = e.getPoint();
            UiContainer container = this.contentPane;
            Point containerPoint = UiUtilities.convertPoint((UiComponent)UiComponent.get((Object)this.glassPane), (Point)glassPanePoint, (UiComponent)this.contentPane);
            if (containerPoint.getY() < 0) {
                container = this.menuBar;
                this.testForDrag(e);
            }
            if (container == null) {
                return;
            }
            if (repaint) {
                Beep.play();
            }
        }

        private void testForDrag(MouseEvent event) {
            if (event.isMousePressed()) {
                this.inDrag = true;
            }
        }
    }
}

