/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.ArrayList;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.simulation.SimulationModelNameInputValidator;
import oracle.bpm.lang.InputValidationException;
import oracle.bpm.lang.Time;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.simulation.RealDistributionCriteria;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.Constraint;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.text.TimeField;

public class SimulationDataDialog
extends OkCancelDialog {
    protected ComboBox<RealDistributionCriteria> criteriaCombo;
    protected TimeField fromField;
    protected ComboBox<Process> modelCombo;
    protected TextField simulationName;
    protected TimeField toField;
    private final Project project;
    private SimulationData simulationData;

    public SimulationDataDialog(UiWindow parent, Project project) {
        super(parent, DesignerMsg.EXTRACT_SIMULATION);
        this.project = project;
        this.buildUI();
        this.setLocationRelativeTo((UiComponent)this.getParent());
        this.setSize(500, 400);
        this.getContentPane().revalidate();
    }

    public SimulationData getSimulationData() {
        return this.simulationData;
    }

    public void ok() {
        this.simulationData = new SimulationData();
        this.simulationData.from = this.fromField.getTime();
        this.simulationData.to = this.toField.getTime();
        this.simulationData.process = (Process)this.modelCombo.getSelectedItem();
        this.simulationData.simulationName = this.simulationName.getText();
        this.simulationData.setCriteria((RealDistributionCriteria)this.criteriaCombo.getSelectedItem());
        try {
            this.simulationData.check();
            this.setUserAccepted(true);
            this.close();
        }
        catch (ProjectException e) {
            MessageDialog.showError((Throwable)e);
        }
    }

    private Panel createRangesPanel(UiContainer parent) {
        Panel result = new Panel(parent, DesignerMsg.RANGES);
        RelativeLayout layout = new RelativeLayout();
        result.setLayout((Layout)layout);
        Label fromLabel = Label.create((UiContainer)result, (Msg)DesignerMsg.FROM);
        Label toLabel = Label.create((UiContainer)result, (Msg)DesignerMsg.TO);
        this.fromField = new TimeField((UiContainer)result, TimeField.Style.DATE_TIME);
        this.fromField.setTime(this.fromField.getTime().addMonths(-1));
        this.toField = new TimeField((UiContainer)result, TimeField.Style.DATE_TIME);
        result.add((UiComponent)fromLabel, (Object)"fromLabel");
        result.add((UiComponent)this.fromField, (Object)"fromField");
        result.add((UiComponent)toLabel, (Object)"toLabel");
        result.add((UiComponent)this.toField, (Object)"toField");
        layout.addConstraint("fromLabel", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP, 5));
        layout.addConstraint("fromLabel", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT, 5));
        layout.addConstraint("fromField", AttributeType.VERTICAL_CENTER, (Constraint)new AttributeConstraint("fromLabel", AttributeType.VERTICAL_CENTER));
        layout.addConstraint("fromField", AttributeType.LEFT, (Constraint)new AttributeConstraint("fromLabel", AttributeType.RIGHT, 5));
        layout.addConstraint("toLabel", AttributeType.TOP, (Constraint)new AttributeConstraint("fromLabel", AttributeType.BOTTOM, 10));
        layout.addConstraint("toLabel", AttributeType.LEFT, (Constraint)new AttributeConstraint("fromLabel", AttributeType.LEFT));
        layout.addConstraint("toField", AttributeType.VERTICAL_CENTER, (Constraint)new AttributeConstraint("toLabel", AttributeType.VERTICAL_CENTER));
        layout.addConstraint("toField", AttributeType.LEFT, (Constraint)new AttributeConstraint("fromField", AttributeType.LEFT));
        return result;
    }

    private void buildUI() {
        UiContainer pane = this.getContentPane();
        Panel mainPanel = new Panel(pane);
        RelativeLayout layout = new RelativeLayout();
        mainPanel.setLayout((Layout)layout);
        Label simulationNameLabel = Label.create((UiContainer)mainPanel, (Msg)DesignerMsg.SIMULATION_NAME);
        this.simulationName = new TextField((UiContainer)mainPanel);
        Panel rangesPanel = this.createRangesPanel((UiContainer)mainPanel);
        Panel modelsPanel = this.createModelSelectionPanel(mainPanel);
        Panel distributionCriteriaPanel = this.createDistributionCriteriaPanel((UiContainer)mainPanel);
        mainPanel.add((UiComponent)simulationNameLabel, (Object)"simNameLabel");
        mainPanel.add((UiComponent)this.simulationName, (Object)"simName");
        mainPanel.add((UiComponent)rangesPanel, (Object)"ranges");
        mainPanel.add((UiComponent)modelsPanel, (Object)"modelCombo");
        mainPanel.add((UiComponent)distributionCriteriaPanel, (Object)"distribution");
        layout.addConstraint("simNameLabel", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP, 15));
        layout.addConstraint("simNameLabel", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT, 5));
        layout.addConstraint("simName", AttributeType.VERTICAL_CENTER, (Constraint)new AttributeConstraint("simNameLabel", AttributeType.VERTICAL_CENTER));
        layout.addConstraint("simName", AttributeType.LEFT, (Constraint)new AttributeConstraint("simNameLabel", AttributeType.RIGHT, 5));
        layout.addConstraint("simName", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT, -10));
        layout.addConstraint("ranges", AttributeType.TOP, (Constraint)new AttributeConstraint("simNameLabel", AttributeType.BOTTOM, 5));
        layout.addConstraint("ranges", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT, 5));
        layout.addConstraint("ranges", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT));
        layout.addConstraint("modelCombo", AttributeType.TOP, (Constraint)new AttributeConstraint("ranges", AttributeType.BOTTOM, 5));
        layout.addConstraint("modelCombo", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT, 5));
        layout.addConstraint("modelCombo", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT));
        layout.addConstraint("distribution", AttributeType.TOP, (Constraint)new AttributeConstraint("modelCombo", AttributeType.BOTTOM, 5));
        layout.addConstraint("distribution", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT, 5));
        layout.addConstraint("distribution", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT));
        pane.add((UiComponent)mainPanel, (Object)"Center");
    }

    private Panel createModelSelectionPanel(Panel mainPanel) {
        Panel result = new Panel((UiContainer)mainPanel, DesignerMsg.PROCESS);
        RelativeLayout layout = new RelativeLayout();
        result.setLayout((Layout)layout);
        this.modelCombo = UiFactory.createComboBox((UiContainer)result, new ArrayList(this.project.getProcesses()));
        this.modelCombo.setSelectedIndex(0);
        result.add(this.modelCombo, (Object)"combo");
        layout.addConstraint("combo", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP, 5));
        layout.addConstraint("combo", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT, 5));
        layout.addConstraint("combo", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT));
        return result;
    }

    private Panel createDistributionCriteriaPanel(UiContainer parent) {
        Panel result = new Panel(parent, DesignerMsg.DISTRIBUTION_CRITERIA);
        RelativeLayout layout = new RelativeLayout();
        result.setLayout((Layout)layout);
        this.criteriaCombo = UiFactory.createComboBox((UiContainer)result, (Object[])RealDistributionCriteria.values());
        this.criteriaCombo.setSelectedIndex(0);
        result.add(this.criteriaCombo, (Object)"combo");
        layout.addConstraint("combo", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP, 5));
        layout.addConstraint("combo", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT, 5));
        layout.addConstraint("combo", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT));
        return result;
    }

    public static class SimulationData {
        Time from;
        Process process;
        String simulationName;
        String targetDir;
        Time to;
        private RealDistributionCriteria criteria;

        public RealDistributionCriteria getCriteria() {
            return this.criteria;
        }

        public void check() throws ProjectException {
            if (this.from == null) {
                // empty if block
            }
            if (this.to == null) {
                // empty if block
            }
            if (this.getModel() == null) {
                // empty if block
            }
            SimulationModelNameInputValidator nameValidator = new SimulationModelNameInputValidator(this.getModel());
            try {
                nameValidator.validate(this.getSimulationName());
            }
            catch (InputValidationException e) {
                throw ProjectException.wrapException((ProjectObject)this.getModel(), (Msg)e.getKey(), (Throwable)e);
            }
            if (this.getCriteria() == null) {
                // empty if block
            }
            if (this.from.compareTo(this.to) > 0) {
                // empty if block
            }
        }

        public Time getFrom() {
            return this.from;
        }

        public void setFrom(Time from) {
            this.from = from;
        }

        public Time getTo() {
            return this.to;
        }

        public void setTo(Time to) {
            this.to = to;
        }

        public String getSimulationName() {
            return this.simulationName;
        }

        public void setSimulationName(String simulationName) {
            this.simulationName = simulationName;
        }

        public Process getModel() {
            return this.process;
        }

        public void setModel(Process process) {
            this.process = process;
        }

        public String getTargetDir() {
            return this.targetDir;
        }

        public void setTargetDir(String targetDir) {
            this.targetDir = targetDir;
        }

        public void setCriteria(RealDistributionCriteria criteria) {
            this.criteria = criteria;
        }
    }
}

