/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.preferences.ProjectPreferencesImpl;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.RelativeLayout;

class SharingInstanceVarsPanel
extends Panel {
    private CheckBox checkBox;
    private boolean dirty;
    private ProjectPreferencesImpl preferences;
    private Project project;

    public SharingInstanceVarsPanel(UiContainer parent, Project project) {
        super(parent, DesignerMsg.PREDEFINED_VARIABLES);
        this.project = project;
        this.build();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.checkBox.setEnabled(enabled);
    }

    public void toPreferences() {
        this.preferences.setAllowsNotToShareInstanceVars(this.checkBox.isSelected());
    }

    private void build() {
        this.preferences = (ProjectPreferencesImpl)this.project.getPreferences();
        RelativeLayout layout = new RelativeLayout();
        this.setLayout((Layout)layout);
        this.checkBox = CheckBox.create((UiContainer)this, (Msg)DesignerMsg.ALLOW_NOT_SHARE_PREDEFINED_VARIABLES);
        this.checkBox.setSelected(this.preferences.getAllowsNotToShareInstanceVars());
        this.checkBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                SharingInstanceVarsPanel.this.setDirty(true);
            }
        });
        LabelMultiline generateRoleTextArea = new LabelMultiline((UiContainer)this, DesignerMsg.ALLOW_NOT_SHARE_PREDEFINED_VARIABLES_EXPLANATION);
        this.add((UiComponent)generateRoleTextArea, "explanationLabel");
        this.add((UiComponent)this.checkBox, "checkBox");
        oracle.bpm.ui.utils.Layout.fixTopDown((RelativeLayout)layout, (String[])new String[]{"explanationLabel", "checkBox"});
    }
}

