/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import oracle.bpm.designer.DesignerMode;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.draw.preferences.ReportPreferencesConstants;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.Constraint;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.RelativeLayout;

public class ReportPropertiesPanel
extends Panel
implements ReportPreferencesConstants {
    boolean isBusinessAnalyst = DesignerMode.isBusinessAnalyst();
    boolean isDeveloper = DesignerMode.isDeveloper();
    private CheckBox includeUseCaseDocumentation;
    private DesignerPreferences preferences;
    private CheckBox printMethodsCheckBox;
    private CheckBox printVariablesCheckBox;

    public ReportPropertiesPanel(UiContainer parent) {
        super(parent, DesignerMsg.GENERAL);
        this.preferences = DesignerPreferences.getPreferences();
        this.setUp();
    }

    private ReportPropertiesPanel(UiContainer parent, DesignerPreferences preferences) {
        super(parent);
        this.preferences = preferences;
        this.setUp();
    }

    public static boolean showOptions(UiWindow parent) {
        DesignerPreferences preferences = DesignerPreferences.getPreferences();
        PreferencesDialog dialog = new PreferencesDialog(preferences, parent);
        dialog.setVisible(true);
        return dialog.userAccepted();
    }

    protected void processOK() {
        if (this.printVariablesCheckBox != null) {
            this.preferences.setIncludeVariablesInReport(this.printVariablesCheckBox.isSelected());
        } else {
            this.preferences.setIncludeVariablesInReport(false);
        }
        if (this.includeUseCaseDocumentation != null) {
            this.preferences.setIncludeUseCaseDocumentationInReport(this.includeUseCaseDocumentation.isSelected());
        }
        if (this.printMethodsCheckBox != null) {
            this.preferences.setIncludeCilsInReport(this.printMethodsCheckBox.isSelected());
        } else {
            this.preferences.setIncludeCilsInReport(false);
        }
    }

    private void setUp() {
        ReportPropertiesPanel c = this;
        RelativeLayout layout = new RelativeLayout();
        c.setLayout((Layout)layout);
        this.includeUseCaseDocumentation = CheckBox.create((UiContainer)c, (Msg)DesignerMsg.INCLUDE_USE_CASE_DOCUMENTATION);
        c.add((UiComponent)this.includeUseCaseDocumentation, "includeUseCaseDocumentationInReport");
        layout.addConstraint("includeUseCaseDocumentationInReport", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP, 5));
        layout.addConstraint("includeUseCaseDocumentationInReport", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT, 5));
        if (this.isDeveloper) {
            this.printMethodsCheckBox = CheckBox.create((UiContainer)c, (Msg)DesignerMsg.INCLUDE_METHODS);
            c.add((UiComponent)this.printMethodsCheckBox, "includeCilsInReport");
            layout.addConstraint("includeCilsInReport", AttributeType.TOP, (Constraint)new AttributeConstraint("includeUseCaseDocumentationInReport", AttributeType.BOTTOM, 5));
            layout.addConstraint("includeCilsInReport", AttributeType.LEFT, (Constraint)new AttributeConstraint("includeUseCaseDocumentationInReport", AttributeType.LEFT));
            this.printVariablesCheckBox = CheckBox.create((UiContainer)c, (Msg)DesignerMsg.INCLUDE_VARIABLES);
            c.add((UiComponent)this.printVariablesCheckBox, "includeVariablesInReport");
            layout.addConstraint("includeVariablesInReport", AttributeType.TOP, (Constraint)new AttributeConstraint("includeCilsInReport", AttributeType.BOTTOM, 5));
            layout.addConstraint("includeVariablesInReport", AttributeType.LEFT, (Constraint)new AttributeConstraint("includeCilsInReport", AttributeType.LEFT));
        }
        this.initComponents();
    }

    private void initComponents() {
        if (this.printMethodsCheckBox != null) {
            this.printMethodsCheckBox.setSelected(this.preferences.getIncludeCilsInReport());
        }
        if (this.printVariablesCheckBox != null) {
            this.printVariablesCheckBox.setSelected(this.preferences.getIncludeVariablesInReport());
        }
        this.includeUseCaseDocumentation.setSelected(this.preferences.getIncludeUseCasesInReport());
    }

    private static class PreferencesDialog
    extends OkCancelDialog {
        ReportPropertiesPanel propertiesPanel;

        public PreferencesDialog(DesignerPreferences preferences, UiWindow parent) {
            super(parent, DesignerMsg.REPORT_OPTIONS, true);
            this.setUp(preferences);
        }

        public void ok() {
            this.propertiesPanel.processOK();
            this.close();
        }

        private void setUp(DesignerPreferences preferences) {
            this.propertiesPanel = new ReportPropertiesPanel(this.getContentPane(), preferences);
            this.getContentPane().add((UiComponent)this.propertiesPanel, (Object)"Center");
            this.setSize(300, 200);
            this.setResizable(false);
            this.setLocationRelativeTo((UiComponent)this.getParent());
        }
    }
}

