/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Frame;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.RelativeLayout;

public class PublishDialog
extends OkCancelDialog {
    private boolean fromScratch;
    private CheckBox fromScratchCheckBox;
    protected static int DEFAULT_DIALOG_WIDTH = 450;

    public PublishDialog(Frame parent) {
        super((UiWindow)parent, ProjectMsg.PUBLISH_PROJECT, true);
        this.init(parent);
    }

    public boolean isFromScratch() {
        return this.fromScratch;
    }

    public void ok() {
        this.fromScratch = this.fromScratchCheckBox.isSelected();
        DesignerPreferences prefs = DesignerPreferences.getPreferences();
        prefs.setRemoveProcessesWhenPublishing(this.fromScratch);
        prefs.store();
        this.close();
    }

    private UiComponent buildOptionsPanel(UiContainer parent) {
        RelativeLayout layout = new RelativeLayout();
        Panel panel = new Panel(parent, DesignerMsg.PUBLISH_FROM_SCRATCH);
        panel.setLayout((Layout)layout);
        this.fromScratchCheckBox = CheckBox.create((UiContainer)panel, (Msg)DesignerMsg.PUBLISH_FROM_SCRATCH);
        panel.add((UiComponent)new LabelMultiline((UiContainer)panel, DesignerMsg.PUBLISH_FROM_SCRATCH_HINT), (Object)"textArea");
        panel.add((UiComponent)this.fromScratchCheckBox, (Object)"fromScratchCheckBox");
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)"textArea", (AttributeType)AttributeType.TOP, (int)0);
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)"textArea", (AttributeType)AttributeType.LEFT, (int)0);
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)"textArea", (AttributeType)AttributeType.RIGHT, (int)0);
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)layout, (String)"fromScratchCheckBox", (AttributeType)AttributeType.TOP, (String)"textArea", (AttributeType)AttributeType.BOTTOM, (int)5);
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)"fromScratchCheckBox", (AttributeType)AttributeType.LEFT, (int)5);
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)"fromScratchCheckBox", (AttributeType)AttributeType.RIGHT, (int)0);
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)"fromScratchCheckBox", (AttributeType)AttributeType.BOTTOM, (int)0);
        return panel;
    }

    private void init(Frame parent) {
        UiComponent optionPanel = this.buildOptionsPanel(this.getContentPane());
        this.getContentPane().add(optionPanel, (Object)"Center");
        this.setSize(DEFAULT_DIALOG_WIDTH, 160);
        this.setLocationRelativeTo((UiComponent)parent);
        this.fromScratchCheckBox.setSelected(false);
    }
}

