/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.ProjectNavigatorTree;
import oracle.bpm.designer.ProjectObjectTreeNode;
import oracle.bpm.designer.action.RefreshCatalogAction;
import oracle.bpm.designer.catalog.tree.CatalogObjectTypeTreeNode;
import oracle.bpm.designer.process.tree.DesignerProcessTreeNode;
import oracle.bpm.extensionpoint.metadata.TreeNodeMetadata;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.ProjectCatalogEvent;
import oracle.bpm.project.ProjectCatalogListener;
import oracle.bpm.project.SharedCatalogEvent;
import oracle.bpm.project.SharedCatalogListener;
import oracle.bpm.project.model.ErrorSource;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.FontStyle;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.tree.TreeNode;

@TreeNodeMetadata(objectType=Project.class)
public class ProjectTreeNode
extends ProjectObjectTreeNode<Project>
implements ProjectCatalogListener,
SharedCatalogListener {
    protected AbstractStudioWorkbench.EngineListener engineListener;

    public ProjectTreeNode(Project project) {
        super((ProjectObject)project);
        if (project instanceof ErrorSource) {
            ErrorSource errorSource = (ErrorSource)project;
            errorSource.addListener(new ErrorSource.Listener(){

                public void stateChanged(ErrorSource descendant) {
                    ProjectTreeNode.this.cachedIcon = null;
                    ProjectTreeNode.this.errorSourceChanged(descendant);
                }
            });
        }
    }

    public FontStyle getFontModifiers() {
        return this.getProject().isOpen() ? FontStyle.BOLD : FontStyle.NORMAL;
    }

    public void cleanNode() {
        this.removeAllChildren();
        this.nodeChanged();
    }

    public ProjectNavigatorTree getProjectTree() {
        return (ProjectNavigatorTree)this.getTree();
    }

    public boolean isLeaf() {
        return !this.getProject().isOpen();
    }

    public CatalogObjectTypeTreeNode getTreeNodeFor(CatalogObjectImpl catalogObject) {
        return this.getTreeNodeFor(catalogObject.getDelegate());
    }

    public CatalogObjectTypeTreeNode getTreeNodeFor(TypeRef typeRef) {
        for (TreeNode treeNode : this.postorder()) {
            CatalogObjectTypeTreeNode node;
            if (!(treeNode instanceof CatalogObjectTypeTreeNode) || !typeRef.equals((node = (CatalogObjectTypeTreeNode)treeNode).getObject().getRef())) continue;
            return node;
        }
        return null;
    }

    public DesignerProcessTreeNode getTreeNodeFor(Process process) {
        for (TreeNode treeNode : this.postorder()) {
            DesignerProcessTreeNode node;
            if (!(treeNode instanceof DesignerProcessTreeNode) || (node = (DesignerProcessTreeNode)treeNode).getModel() != process) continue;
            return node;
        }
        return null;
    }

    public void projectCatalogChanged(ProjectCatalogEvent event) {
        if (event.getEventType() == 0 || event.getEventType() == 1) {
            RefreshCatalogAction refreshCatalog = new RefreshCatalogAction();
            refreshCatalog.doIt();
        }
    }

    public void sharedCatalogChanged(SharedCatalogEvent event) {
        if (event.getEventType() == 0 || event.getEventType() == 1) {
            RefreshCatalogAction refreshCatalog = new RefreshCatalogAction();
            refreshCatalog.doIt();
        }
    }

    public void setProject(Project project) {
        this.setUserObject(project);
        if (project != null) {
            this.addListeners();
        }
    }

    public boolean isProjectOpen() {
        return this.getProject() != null && this.getProject().isOpen();
    }

    public CatalogObjectTypeTreeNode getCatalogNode() {
        this.ensureLoaded();
        for (TreeNode node : this.getChildren()) {
            if (!(node instanceof CatalogObjectTypeTreeNode)) continue;
            return (CatalogObjectTypeTreeNode)node;
        }
        return null;
    }

    @Override
    protected void onLoading() {
        if (this.getProject().isOpen()) {
            this.buildTree();
        }
    }

    protected void removeListeners() {
        AbstractStudioWorkbench.removeEngineListener(this.engineListener);
    }

    protected void errorSourceChanged(ErrorSource descendant) {
        ProjectNavigatorTree projectTree = this.getProjectTree();
        if (projectTree == null) {
            return;
        }
        ArrayList<ProjectObject> path = new ArrayList<ProjectObject>();
        for (ProjectObject po = (ProjectObject)descendant; po != null; po = po.getParentObject()) {
            path.add(0, po);
        }
        Iterator it = path.iterator();
        assert (it.next() == this.getProject());
        ProjectListener<ProjectObject> delegate = projectTree.getProjectListenerDelegate();
        ProjectTreeNode current = this;
        projectTree.fireNodeChanged(current);
        if (delegate != null) {
            delegate.objectChanged(this.getProjectObject(), ProjectEvent.CHANGE(this.getProjectObject()));
        }
        while (it.hasNext() && current != null && current.isLoaded()) {
            ProjectObject child = (ProjectObject)it.next();
            if ((current = current.findTreeNodeByUserObject(child)) == null) continue;
            projectTree.fireNodeChanged(current);
            if (delegate == null) continue;
            delegate.objectChanged(child, ProjectEvent.CHANGE((ProjectObject)child));
        }
    }

    private void buildTree() {
        if (this.getProject() == null) {
            return;
        }
        for (ProjectObject child : this.getFilter().getChildren((ProjectObjectContainer)this.getProject())) {
            this.addDynamic(child, null);
        }
    }

    private void addListeners() {
        this.engineListener = new AbstractStudioWorkbench.EngineListener(){

            @Override
            public void engineStarted(Project project) {
                Project currentProject = ProjectTreeNode.this.getProject();
                if (currentProject == null) {
                    return;
                }
                if (currentProject.getName().equals(project.getName())) {
                    UiUtilities.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ProjectTreeNode.this.nodeChanged();
                        }
                    });
                }
            }

            @Override
            public void engineStopped(Project project) {
                if (ProjectTreeNode.this.getProject() != null && ProjectTreeNode.this.getProject().getName().equals(project.getName())) {
                    UiUtilities.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ProjectTreeNode.this.nodeChanged();
                        }
                    });
                }
            }
        };
        AbstractStudioWorkbench.addEngineListener(this.engineListener);
    }
}

